/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.relations.compilation2;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.elaboration.relations.compilation.UnsolvableQueryException;
import org.simantics.scl.compiler.elaboration.relations.compilation2.GlobalConstraint;

public class ConjunctiveQuery {
    int variableCount;
    GlobalConstraint[] constraints;
    ArrayList<LocalVariableRef>[] potentialProducers;
    private TIntArrayList[] constraintsPerVariable;
    private int[] depths;
    private int[] lowpoints;
    TIntHashSet seeds;
    int ROOT;
    TIntHashSet cutpoints = new TIntHashSet();

    public ConjunctiveQuery(int variableCount, GlobalConstraint[] constraints) throws UnsolvableQueryException {
        this.variableCount = variableCount;
        this.constraints = constraints;
        this.initializeProducers();
        this.computeProducerFixpoint();
        this.cutPointAnalysis();
        this.computeProducerFixpoint();
        this.checkNonproducableVariables();
    }

    private void reportUnsolvableConstraint(int constraintId) throws UnsolvableQueryException {
        throw new UnsolvableQueryException("Cannot solve constraint " + this.constraints[constraintId]);
    }

    private void reportUnsolvableVariable(int variableId) throws UnsolvableQueryException {
        throw new UnsolvableQueryException("Cannot solve variable " + variableId);
    }

    private void initializeProducers() throws UnsolvableQueryException {
        this.potentialProducers = new ArrayList[this.variableCount];
        int i = 0;
        while (i < this.variableCount) {
            this.potentialProducers[i] = new ArrayList();
            ++i;
        }
        int constraintId = 0;
        while (constraintId < this.constraints.length) {
            GlobalConstraint constraint = this.constraints[constraintId];
            constraint.producedVariables = 0L;
            constraint.updateConsumedVariables();
            if ((constraint.consumedVariables & constraint.producedVariables) != 0L) {
                this.reportUnsolvableConstraint(constraintId);
            }
            int localVariableId = 0;
            while (localVariableId < constraint.variables.length) {
                if ((constraint.consumedVariables >> localVariableId & 1L) == 0L) {
                    this.potentialProducers[constraint.variables[localVariableId]].add(new LocalVariableRef(constraintId, localVariableId));
                }
                ++localVariableId;
            }
            ++constraintId;
        }
    }

    void computeProducerFixpoint() throws UnsolvableQueryException {
        TIntHashSet pendingProducers = new TIntHashSet();
        TIntArrayList pendingProducersStack = new TIntArrayList();
        int i = 0;
        while (i < this.variableCount) {
            LocalVariableRef ref;
            ArrayList<LocalVariableRef> refs = this.potentialProducers[i];
            if (refs.size() == 1 && this.setAsProducer(ref = refs.get(0)) && pendingProducers.add(ref.constraintId)) {
                pendingProducersStack.add(ref.constraintId);
            }
            ++i;
        }
        while (!pendingProducers.isEmpty()) {
            int constraintId = pendingProducersStack.removeAt(pendingProducersStack.size() - 1);
            pendingProducers.remove(constraintId);
            GlobalConstraint constraint = this.constraints[constraintId];
            long oldConsumedVariables = constraint.consumedVariables;
            constraint.updateConsumedVariables();
            if ((constraint.consumedVariables & constraint.producedVariables) != 0L) {
                this.reportUnsolvableConstraint(constraintId);
            }
            long diffConsumedVariables = constraint.consumedVariables & (oldConsumedVariables ^ 0xFFFFFFFFFFFFFFFFL);
            int i2 = 0;
            while (diffConsumedVariables != 0L) {
                if ((diffConsumedVariables & 1L) != 0L) {
                    LocalVariableRef ref;
                    ArrayList<LocalVariableRef> refs = this.potentialProducers[constraint.variables[i2]];
                    int j = 0;
                    while (j < refs.size()) {
                        if (refs.get((int)j).constraintId == constraintId) {
                            LocalVariableRef ref2 = refs.remove(refs.size() - 1);
                            if (j < refs.size()) {
                                refs.set(j, ref2);
                            }
                        }
                        ++j;
                    }
                    if (refs.size() == 1 && this.setAsProducer(ref = refs.get(0)) && pendingProducers.add(ref.constraintId)) {
                        pendingProducersStack.add(ref.constraintId);
                    }
                }
                ++i2;
                diffConsumedVariables >>= 1;
            }
        }
    }

    void checkNonproducableVariables() throws UnsolvableQueryException {
        int i = 0;
        while (i < this.variableCount) {
            if (this.potentialProducers[i].isEmpty()) {
                this.reportUnsolvableVariable(i);
            }
            ++i;
        }
    }

    private boolean setAsProducer(LocalVariableRef localVariableRef) {
        GlobalConstraint constraint = this.constraints[localVariableRef.constraintId];
        int localVariableId = localVariableRef.localVariableId;
        if ((constraint.producedVariables >> localVariableId & 1L) == 1L) {
            return false;
        }
        constraint.producedVariables |= (long)(1 << localVariableId);
        return true;
    }

    private void cutPointAnalysis() {
        this.constraintsPerVariable = new TIntArrayList[this.variableCount];
        int variableId = 0;
        while (variableId < this.variableCount) {
            this.constraintsPerVariable[variableId] = new TIntArrayList(4);
            ++variableId;
        }
        int constraintId = 0;
        while (constraintId < this.constraints.length) {
            GlobalConstraint constraint = this.constraints[constraintId];
            int[] nArray = constraint.variables;
            int n = constraint.variables.length;
            int n2 = 0;
            while (n2 < n) {
                int variableId2 = nArray[n2];
                this.constraintsPerVariable[variableId2].add(constraintId);
                ++n2;
            }
            ++constraintId;
        }
        this.seeds = new TIntHashSet();
        constraintId = 0;
        while (constraintId < this.constraints.length) {
            if (this.constraints[constraintId].isSeed()) {
                this.seeds.add(constraintId);
            }
            ++constraintId;
        }
        this.depths = new int[this.constraints.length + 1];
        this.lowpoints = new int[this.constraints.length + 1];
        this.ROOT = this.constraints.length;
        this.cutPointAnalysisRec(-1, this.ROOT, 1);
        int[] nArray = this.cutpoints.toArray();
        int n = nArray.length;
        int n3 = 0;
        while (n3 < n) {
            int cp = nArray[n3];
            GlobalConstraint constraint = this.constraints[cp];
            int depth = this.depths[cp];
            int[] nArray2 = constraint.variables;
            int n4 = constraint.variables.length;
            int n5 = 0;
            while (n5 < n4) {
                int v = nArray2[n5];
                ArrayList<LocalVariableRef> refs = this.potentialProducers[v];
                if (refs.size() != 1) {
                    int i = 0;
                    while (i < refs.size()) {
                        LocalVariableRef ref = refs.get(i);
                        if (ref.constraintId != cp && this.lowpoints[ref.constraintId] >= depth) {
                            LocalVariableRef lastRef = refs.remove(refs.size() - 1);
                            if (i < refs.size()) {
                                refs.set(i, lastRef);
                                --i;
                            }
                        }
                        ++i;
                    }
                }
                ++n5;
            }
            ++n3;
        }
    }

    private void cutPointAnalysisRec(int parent, int cur, int depth) {
        this.depths[cur] = depth;
        int lowpoint = depth;
        int[] nArray = this.neighborConstraints(cur).toArray();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int child = nArray[n2];
            if (child != parent) {
                int childDepth = this.depths[child];
                if (childDepth == 0) {
                    this.cutPointAnalysisRec(cur, child, depth + 1);
                    int childLowpoint = this.lowpoints[child];
                    if (childLowpoint >= depth && cur != this.ROOT) {
                        this.cutpoints.add(cur);
                    }
                    lowpoint = Math.min(lowpoint, childLowpoint);
                } else {
                    lowpoint = Math.min(lowpoint, childDepth);
                }
            }
            ++n2;
        }
        this.lowpoints[cur] = lowpoint;
    }

    private TIntHashSet neighborConstraints(int constraintId) {
        if (constraintId == this.ROOT) {
            return this.seeds;
        }
        TIntHashSet neighbor = new TIntHashSet();
        GlobalConstraint constraint = this.constraints[constraintId];
        int i = 0;
        while (i < constraint.variables.length) {
            boolean onlyConsumes = (constraint.consumedVariables >> i & 1L) == 1L;
            int[] nArray = constraint.variables;
            int n = constraint.variables.length;
            int n2 = 0;
            while (n2 < n) {
                int variableId = nArray[n2];
                int[] nArray2 = this.constraintsPerVariable[variableId].toArray();
                int n3 = nArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    int otherConstraintId = nArray2[n4];
                    if (onlyConsumes) {
                        GlobalConstraint otherConstraint = this.constraints[otherConstraintId];
                        int j = 0;
                        while (j < otherConstraint.variables.length) {
                            if (otherConstraint.variables[j] != variableId || (otherConstraint.consumedVariables >> j & 1L) != 1L) {
                                ++j;
                                continue;
                            }
                            break;
                        }
                    } else {
                        neighbor.add(otherConstraintId);
                    }
                    ++n4;
                }
                ++n2;
            }
            ++i;
        }
        if (this.seeds.contains(constraintId)) {
            neighbor.add(this.ROOT);
        }
        neighbor.remove(constraintId);
        return neighbor;
    }

    public void printAnalysis() {
        GlobalConstraint[] globalConstraintArray = this.constraints;
        int n = this.constraints.length;
        int n2 = 0;
        while (n2 < n) {
            GlobalConstraint constraint = globalConstraintArray[n2];
            System.out.println(constraint);
            System.out.print("    Consumes:");
            int i = 0;
            while (i < constraint.variables.length) {
                if ((constraint.consumedVariables >> i & 1L) != 0L) {
                    System.out.print(" " + constraint.variables[i]);
                }
                ++i;
            }
            System.out.println();
            System.out.print("    Produces:");
            i = 0;
            while (i < constraint.variables.length) {
                if ((constraint.producedVariables >> i & 1L) != 0L) {
                    System.out.print(" " + constraint.variables[i]);
                }
                ++i;
            }
            System.out.println();
            ++n2;
        }
        int i = 0;
        while (i < this.variableCount) {
            System.out.println("Var" + i + ": " + this.potentialProducers[i]);
            ++i;
        }
        System.out.println("Cutpoints: " + this.cutpoints);
        int constraintId = 0;
        while (constraintId < this.constraints.length) {
            System.out.println("    " + this.constraints[constraintId] + ": depth=" + this.depths[constraintId] + ", lowpoint=" + this.lowpoints[constraintId]);
            ++constraintId;
        }
    }

    private static class LocalVariableRef {
        final int constraintId;
        final int localVariableId;

        public LocalVariableRef(int constraintId, int localVariableId) {
            this.constraintId = constraintId;
            this.localVariableId = localVariableId;
        }

        public String toString() {
            return "(" + this.constraintId + "," + this.localVariableId + ")";
        }
    }
}

