/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.relations.compilation;

import gnu.trove.TIntCollection;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.elaboration.relations.compilation.QueryConstraint;
import org.simantics.scl.types.Type;

public class RelationConstraint
extends QueryConstraint {
    Type[] typeParameters;
    Expression[] typeConstraintEvidences;
    SCLRelation relation;
    Expression[] parameters;
    int[] allVariables;
    int[] requiredVariables;
    int[] optionalVariableByParameter;
    int localBoundVariables;

    public RelationConstraint(Type[] typeParameters, Expression[] typeConstraintEvidences, SCLRelation relation, Expression[] parameters, TObjectIntHashMap<Variable> variableIdMap) {
        this.typeParameters = typeParameters;
        this.typeConstraintEvidences = typeConstraintEvidences;
        this.relation = relation;
        this.parameters = parameters;
        TIntHashSet requiredVariablesSet = new TIntHashSet();
        this.optionalVariableByParameter = new int[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            Expression parameter = parameters[i];
            if (parameter instanceof EVariable) {
                Variable variable = ((EVariable)parameter).getVariable();
                this.optionalVariableByParameter[i] = variableIdMap.get((Object)variable);
            } else {
                parameter.collectVars(variableIdMap, requiredVariablesSet);
                this.optionalVariableByParameter[i] = -1;
            }
            ++i;
        }
        this.requiredVariables = requiredVariablesSet.toArray();
        TIntHashSet allVariablesSet = new TIntHashSet((TIntCollection)requiredVariablesSet);
        int[] nArray = this.optionalVariableByParameter;
        int n = this.optionalVariableByParameter.length;
        int n2 = 0;
        while (n2 < n) {
            int v = nArray[n2];
            if (v >= 0) {
                allVariablesSet.add(v);
            }
            ++n2;
        }
        this.allVariables = allVariablesSet.toArray();
    }

    @Override
    public int[] getVariables() {
        return this.allVariables;
    }

    @Override
    public void updateSelectivity(boolean[] boundVariables) {
        int[] nArray = this.requiredVariables;
        int n = this.requiredVariables.length;
        int n2 = 0;
        while (n2 < n) {
            int v = nArray[n2];
            if (!boundVariables[v]) {
                this.selectivity = Double.POSITIVE_INFINITY;
                return;
            }
            ++n2;
        }
        this.localBoundVariables = 0;
        int i = 0;
        while (i < this.optionalVariableByParameter.length) {
            int v = this.optionalVariableByParameter[i];
            if (v < 0 || boundVariables[v]) {
                this.localBoundVariables |= 1 << i;
            }
            ++i;
        }
        this.selectivity = this.relation.getSelectivity(this.localBoundVariables);
    }

    @Override
    public Expression generateIteration(SimplificationContext context, Expression continuation) {
        return null;
    }

    public String toString() {
        return "RelationConstraint(requires=" + Arrays.toString(this.requiredVariables) + ", optionals=" + Arrays.toString(this.optionalVariableByParameter) + ")";
    }
}

