/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.relations.compilation;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import org.simantics.scl.compiler.elaboration.relations.compilation.ConstraintPriorityQueue;
import org.simantics.scl.compiler.elaboration.relations.compilation.QueryConstraint;
import org.simantics.scl.compiler.elaboration.relations.compilation.UnsolvableQueryException;

public class QueryPlanner {
    public static void orderConstraints(int variableCount, QueryConstraint[] constraints) throws UnsolvableQueryException {
        int v;
        int n;
        int[] nArray;
        ConstraintPriorityQueue priorityQueue = new ConstraintPriorityQueue();
        ArrayList[] constraintsByVariables = new ArrayList[variableCount];
        int i = 0;
        while (i < variableCount) {
            constraintsByVariables[i] = new ArrayList(2);
            ++i;
        }
        boolean[] boundVariables = new boolean[variableCount];
        ArrayList<QueryConstraint> result = new ArrayList<QueryConstraint>();
        int i2 = 0;
        while (i2 < constraints.length) {
            QueryConstraint constraint = constraints[i2];
            constraint.orderId = i2;
            nArray = constraint.getVariables();
            n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                v = nArray[n2];
                constraintsByVariables[v].add(constraint);
                ++n2;
            }
            constraint.updateSelectivity(boundVariables);
            if (constraint.selectivity != Double.POSITIVE_INFINITY) {
                priorityQueue.add(constraint);
            }
            ++i2;
        }
        while (!priorityQueue.isEmpty()) {
            QueryConstraint best = priorityQueue.pop();
            result.add(best);
            best.used = true;
            THashSet activated = new THashSet();
            nArray = best.getVariables();
            n = nArray.length;
            int n3 = 0;
            while (n3 < n) {
                v = nArray[n3];
                if (!boundVariables[v]) {
                    boundVariables[v] = true;
                    activated.addAll((Collection)constraintsByVariables[v]);
                    constraintsByVariables[v] = null;
                }
                ++n3;
            }
            for (QueryConstraint constraint : activated) {
                if (constraint.used) continue;
                constraint.updateSelectivity(boundVariables);
                if (constraint.selectivity == Double.POSITIVE_INFINITY) continue;
                priorityQueue.add(constraint);
            }
        }
        if (result.size() != constraints.length) {
            throw new UnsolvableQueryException();
        }
        result.toArray(constraints);
    }
}

