/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.relations.compilation;

import java.util.Arrays;
import org.simantics.scl.compiler.elaboration.relations.compilation.QueryConstraint;

public class ConstraintPriorityQueue {
    QueryConstraint[] constraints = new QueryConstraint[8];
    int size;

    public void add(QueryConstraint constraint) {
        if (constraint.heapPos < 0) {
            if (this.size == this.constraints.length) {
                this.increaseCapacity();
            }
            this.updateDown(this.size, constraint);
            ++this.size;
        } else {
            this.updateDown(constraint.heapPos, constraint);
        }
    }

    public QueryConstraint pop() {
        QueryConstraint result = this.constraints[0];
        this.updateUp(0, this.constraints[--this.size]);
        return result;
    }

    private static int parentPos(int pos) {
        return pos - 1 >> 1;
    }

    private static int firstChildPos(int pos) {
        return (pos << 1) + 1;
    }

    private void updateUp(int pos, QueryConstraint constraint) {
        int firstChildPos;
        while ((firstChildPos = ConstraintPriorityQueue.firstChildPos(pos)) < this.size) {
            QueryConstraint secondChild;
            QueryConstraint firstChild = this.constraints[firstChildPos];
            if (firstChildPos + 1 == this.size || firstChild.hasHigherPriorityThan(secondChild = this.constraints[firstChildPos + 1])) {
                if (constraint.hasHigherPriorityThan(firstChild)) break;
                firstChild.heapPos = pos;
                this.constraints[pos] = firstChild;
                pos = firstChildPos;
                continue;
            }
            if (constraint.hasHigherPriorityThan(secondChild)) break;
            secondChild.heapPos = pos;
            this.constraints[pos] = secondChild;
            pos = firstChildPos + 1;
        }
        constraint.heapPos = pos;
        this.constraints[pos] = constraint;
    }

    private void updateDown(int pos, QueryConstraint constraint) {
        while (pos > 0) {
            int parentPos = ConstraintPriorityQueue.parentPos(pos);
            QueryConstraint parent = this.constraints[parentPos];
            if (parent.hasHigherPriorityThan(constraint)) break;
            parent.heapPos = pos;
            this.constraints[pos] = parent;
            pos = parentPos;
        }
        constraint.heapPos = pos;
        this.constraints[pos] = constraint;
    }

    private void increaseCapacity() {
        this.constraints = Arrays.copyOf(this.constraints, this.constraints.length * 2);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }
}

