/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.relations;

import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.contexts.EnvironmentalContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Expressions;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryCompilationContext;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.types.TPred;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.kinds.Kinds;

public class LocalRelation
implements SCLRelation {
    String name;
    Type[] parameterTypes;
    public Variable table;
    public Expression[] constraints;
    private static final Name MSet_contains = Name.create("MSet", "contains");
    private static final Name EQ = Name.create("Prelude", "==");

    public LocalRelation(String name, int arity) {
        this.name = name;
        this.parameterTypes = new Type[arity];
        int i = 0;
        while (i < arity) {
            this.parameterTypes[i] = Types.metaVar(Kinds.STAR);
            ++i;
        }
        this.constraints = new Expression[this.parameterTypes.length];
        i = 0;
        while (i < this.parameterTypes.length) {
            EVariable constraint = new EVariable(null);
            constraint.setType(Types.pred(Types.EQ, this.parameterTypes[i]));
            this.constraints[i] = constraint;
            ++i;
        }
    }

    public int getArity() {
        return this.parameterTypes.length;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public TVar[] getTypeVariables() {
        return TVar.EMPTY_ARRAY;
    }

    @Override
    public TPred[] getTypeConstraints() {
        return TPred.EMPTY_ARRAY;
    }

    @Override
    public Type[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public Type getReadingEffect() {
        return Types.NO_EFFECTS;
    }

    @Override
    public Type getWritingEffect() {
        return null;
    }

    @Override
    public double getSelectivity(int boundVariabes) {
        double s = 0.95;
        int i = 0;
        while (i < this.parameterTypes.length) {
            if ((boundVariabes & 1) == 0) {
                s *= 10.0;
            }
            ++i;
            boundVariabes >>= 1;
        }
        return s;
    }

    @Override
    public void generate(QueryCompilationContext context, Type[] typeParameters, Expression[] typeConstraintEvidences, Variable[] parameters, int boundVariables) {
        SimplificationContext simplificationContext = context.getSimplificationContext();
        if (boundVariables + 1 == 1 << parameters.length) {
            context.condition(Expressions.apply((EnvironmentalContext)simplificationContext, (Type)Types.PROC, MSet_contains, Types.tuple(this.parameterTypes), Expressions.var(this.table), Expressions.tuple(Expressions.vars(parameters))));
        } else {
            Variable[] aux = new Variable[parameters.length];
            int i = 0;
            while (i < parameters.length) {
                aux[i] = (boundVariables >> i & 1) == 1 ? new Variable("aux_" + parameters[i].getName(), parameters[i].getType()) : parameters[i];
                ++i;
            }
            Variable row = new Variable("row", Types.tuple(this.parameterTypes));
            int i2 = 0;
            while (i2 < parameters.length) {
                if ((boundVariables >> i2 & 1) == 1) {
                    context.condition(Expressions.apply((EnvironmentalContext)simplificationContext, (Type)Types.NO_EFFECTS, EQ, this.parameterTypes[i2], this.constraints[i2].copy(), Expressions.var(aux[i2]), Expressions.var(parameters[i2])));
                }
                ++i2;
            }
            context.match(simplificationContext.tuple(simplificationContext.vars(aux)), new EVariable(row), false);
            context.iterateMSet(row, new EVariable(this.table));
        }
    }

    @Override
    public Expression generateEnforce(SimplificationContext context, Type[] typeParameters, Expression[] typeConstraintEvidences, Variable[] parameters) {
        throw new UnsupportedOperationException();
    }
}

