/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.relations;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLet;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.block.GuardStatement;
import org.simantics.scl.compiler.elaboration.java.Builtins;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.relations.AtomicFormula;
import org.simantics.scl.compiler.elaboration.relations.compilation.QueryConstraint;
import org.simantics.scl.compiler.elaboration.relations.compilation.QueryPlanner;
import org.simantics.scl.compiler.elaboration.relations.compilation.UnsolvableQueryException;
import org.simantics.scl.compiler.parsing.Symbol;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.kinds.Kinds;

public class ConjunctiveQuery
extends Symbol {
    private static final String[] NO_UNKNOWN_NAMES = new String[0];
    public static final int R = 1;
    public static final int W = 2;
    public static final int RW = 3;
    String[] unknownNames;
    ArrayList<Variable> unknowns;
    AtomicFormula[] formulas;

    private ConjunctiveQuery(String[] unknownNames, AtomicFormula[] formulas) {
        this.unknownNames = unknownNames;
        this.formulas = formulas;
    }

    private ConjunctiveQuery(ArrayList<Variable> unknowns, AtomicFormula[] formulas) {
        this.unknowns = unknowns;
        this.formulas = formulas;
    }

    private ConjunctiveQuery(AtomicFormula[] formulas) {
        this.formulas = formulas;
    }

    private void handleExistsStatement(TranslationContext context) {
        this.unknownNames = NO_UNKNOWN_NAMES;
        if (this.formulas.length == 0) {
            return;
        }
        if (!(this.formulas[0].ast instanceof GuardStatement)) {
            return;
        }
        Expression exp = ((GuardStatement)this.formulas[0].ast).value;
        if (!(exp instanceof EApply)) {
            return;
        }
        EApply apply = (EApply)exp;
        if (!(apply.getFunction() instanceof EVar)) {
            return;
        }
        if (!((EVar)apply.getFunction()).name.equals("exists")) {
            return;
        }
        Expression[] pars = apply.getParameters();
        this.unknownNames = new String[pars.length];
        int i = 0;
        while (i < pars.length) {
            if (!(pars[i] instanceof EVar)) {
                context.getErrorLog().log(pars[i].getLocation(), "Exists statement may only contain variables as parameters.");
                this.unknownNames = NO_UNKNOWN_NAMES;
                break;
            }
            this.unknownNames[i] = ((EVar)pars[i]).name;
            ++i;
        }
        this.formulas = Arrays.copyOfRange(this.formulas, 1, this.formulas.length);
    }

    public void resolve(TranslationContext context) {
        if (this.unknownNames == null) {
            this.handleExistsStatement(context);
        }
        this.unknowns = new ArrayList(this.unknownNames.length);
        int i = 0;
        while (i < this.unknownNames.length) {
            this.unknowns.add(context.newVariable(this.unknownNames[i]));
            ++i;
        }
        AtomicFormula[] atomicFormulaArray = this.formulas;
        int n = this.formulas.length;
        int n2 = 0;
        while (n2 < n) {
            AtomicFormula formula = atomicFormulaArray[n2];
            formula.resolve(context);
            ++n2;
        }
    }

    public void collectRefs(TObjectIntHashMap<SCLValue> allRefs, TIntHashSet refs) {
        AtomicFormula[] atomicFormulaArray = this.formulas;
        int n = this.formulas.length;
        int n2 = 0;
        while (n2 < n) {
            AtomicFormula formula = atomicFormulaArray[n2];
            formula.collectRefs(allRefs, refs);
            ++n2;
        }
    }

    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        AtomicFormula[] atomicFormulaArray = this.formulas;
        int n = this.formulas.length;
        int n2 = 0;
        while (n2 < n) {
            AtomicFormula formula = atomicFormulaArray[n2];
            formula.collectVars(allVars, vars);
            ++n2;
        }
    }

    public void collectFreeVariables(THashSet<Variable> vars) {
        AtomicFormula[] atomicFormulaArray = this.formulas;
        int n = this.formulas.length;
        int n2 = 0;
        while (n2 < n) {
            AtomicFormula formula = atomicFormulaArray[n2];
            formula.collectFreeVariables(vars);
            ++n2;
        }
        for (Variable unknown : this.unknowns) {
            vars.remove((Object)unknown);
        }
    }

    public void checkType(int rw, TypingContext context) {
        for (Variable unknown : this.unknowns) {
            unknown.setType(Types.metaVar(Kinds.STAR));
        }
        AtomicFormula[] atomicFormulaArray = this.formulas;
        int n = this.formulas.length;
        int n2 = 0;
        while (n2 < n) {
            AtomicFormula formula = atomicFormulaArray[n2];
            formula.checkType(rw, context);
            ++n2;
        }
    }

    public void simplify(SimplificationContext context) {
        AtomicFormula[] atomicFormulaArray = this.formulas;
        int n = this.formulas.length;
        int n2 = 0;
        while (n2 < n) {
            AtomicFormula formula = atomicFormulaArray[n2];
            formula.simplify(context);
            ++n2;
        }
    }

    public void addUnknowns(Collection<Variable> freeVariables) {
        for (Variable var : freeVariables) {
            this.unknowns.add(var);
        }
    }

    public Expression generateIteration(SimplificationContext context, Expression innerExpression) throws UnsolvableQueryException {
        ArrayList<QueryConstraint> constraints = new ArrayList<QueryConstraint>(this.formulas.length);
        TObjectIntHashMap variableIdMap = new TObjectIntHashMap(this.unknowns.size(), 0.5f, -1);
        int i = 0;
        while (i < this.unknowns.size()) {
            variableIdMap.put((Object)this.unknowns.get(i), i);
            ++i;
        }
        AtomicFormula[] atomicFormulaArray = this.formulas;
        int n = this.formulas.length;
        int n2 = 0;
        while (n2 < n) {
            AtomicFormula formula = atomicFormulaArray[n2];
            formula.flatten(this.unknowns, (TObjectIntHashMap<Variable>)variableIdMap, constraints);
            ++n2;
        }
        QueryConstraint[] plan = constraints.toArray(new QueryConstraint[constraints.size()]);
        QueryPlanner.orderConstraints(variableIdMap.size(), plan);
        int i2 = plan.length - 1;
        while (i2 >= 0) {
            innerExpression = plan[i2].generateIteration(context, innerExpression);
            --i2;
        }
        return innerExpression;
    }

    public Expression generateEnforce(SimplificationContext context) {
        Expression result = new EConstant(Builtins.TUPLE_CONSTRUCTORS[0]);
        int i = this.formulas.length - 1;
        while (i >= 0) {
            result = new ESimpleLet(new Variable("_", Types.tupleConstructor(0)), this.formulas[i].generateEnforce(context), result);
            --i;
        }
        return result;
    }

    public Type getEffect(int rw) {
        AtomicFormula formula;
        int n;
        int n2;
        AtomicFormula[] atomicFormulaArray;
        THashSet effects = new THashSet();
        if ((rw & 1) != 0) {
            atomicFormulaArray = this.formulas;
            n2 = this.formulas.length;
            n = 0;
            while (n < n2) {
                formula = atomicFormulaArray[n];
                effects.add((Object)formula.relation.getReadingEffect());
                ++n;
            }
        }
        if ((rw & 2) != 0) {
            atomicFormulaArray = this.formulas;
            n2 = this.formulas.length;
            n = 0;
            while (n < n2) {
                formula = atomicFormulaArray[n];
                effects.add((Object)formula.relation.getWritingEffect());
                ++n;
            }
        }
        return Types.union((Type[])effects.toArray((Object[])new Type[effects.size()]));
    }
}

