/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.relations;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLet;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.block.BindStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.GuardStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.LetStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.Statement;
import org.simantics.scl.compiler.elaboration.java.CheckRelation;
import org.simantics.scl.compiler.elaboration.java.EqRelation;
import org.simantics.scl.compiler.elaboration.java.MemberRelation;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.elaboration.relations.compilation.QueryConstraint;
import org.simantics.scl.compiler.elaboration.relations.compilation.RelationConstraint;
import org.simantics.scl.compiler.parsing.Symbol;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.types.TPred;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;

public class AtomicFormula
extends Symbol {
    Statement ast;
    SCLRelation relation;
    Type[] typeParameters;
    Expression[] typeConstraintEvidences;
    Expression[] parameters;

    private AtomicFormula(SCLRelation relation, Expression[] parameters) {
        this.relation = relation;
        this.parameters = parameters;
    }

    private AtomicFormula(Statement statement) {
        this.ast = statement;
    }

    public void resolve(TranslationContext context) {
        if (this.ast instanceof GuardStatement) {
            EApply apply;
            Expression function;
            Expression exp = ((GuardStatement)this.ast).value;
            if (exp instanceof EApply && (function = (apply = (EApply)exp).getFunction()) instanceof EVar) {
                String relationName = ((EVar)function).name;
                this.relation = context.resolveRelation(this.getLocation(), relationName);
                if (this.relation != null) {
                    this.parameters = apply.getParameters();
                    int i = 0;
                    while (i < this.parameters.length) {
                        this.parameters[i] = this.parameters[i].resolve(context);
                        ++i;
                    }
                    return;
                }
            }
            this.relation = CheckRelation.INSTANCE;
            this.parameters = new Expression[]{exp.resolve(context)};
        } else if (this.ast instanceof LetStatement) {
            LetStatement statement = (LetStatement)this.ast;
            this.relation = EqRelation.INSTANCE;
            this.parameters = new Expression[]{statement.pattern.resolve(context), statement.value.resolve(context)};
        } else if (this.ast instanceof BindStatement) {
            BindStatement statement = (BindStatement)this.ast;
            this.relation = MemberRelation.INSTANCE;
            this.parameters = new Expression[]{statement.pattern.resolve(context), statement.value.resolve(context)};
        }
    }

    public void collectRefs(TObjectIntHashMap<SCLValue> allRefs, TIntHashSet refs) {
        Expression[] expressionArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Expression parameter = expressionArray[n2];
            parameter.collectRefs(allRefs, refs);
            ++n2;
        }
    }

    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        Expression[] expressionArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Expression parameter = expressionArray[n2];
            parameter.collectVars(allVars, vars);
            ++n2;
        }
        if (this.typeConstraintEvidences != null) {
            expressionArray = this.typeConstraintEvidences;
            n = this.typeConstraintEvidences.length;
            n2 = 0;
            while (n2 < n) {
                Expression evidence = expressionArray[n2];
                evidence.collectVars(allVars, vars);
                ++n2;
            }
        }
    }

    public void collectFreeVariables(THashSet<Variable> vars) {
        Expression[] expressionArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Expression parameter = expressionArray[n2];
            parameter.collectFreeVariables(vars);
            ++n2;
        }
        if (this.typeConstraintEvidences != null) {
            expressionArray = this.typeConstraintEvidences;
            n = this.typeConstraintEvidences.length;
            n2 = 0;
            while (n2 < n) {
                Expression evidence = expressionArray[n2];
                evidence.collectFreeVariables(vars);
                ++n2;
            }
        }
    }

    public void checkType(int rw, TypingContext context) {
        if ((rw & 1) != 0) {
            Type readingEffect = this.relation.getReadingEffect();
            if (readingEffect == null) {
                context.getErrorLog().log(this.getLocation(), "Relation does not support reading.");
            } else {
                context.declareEffect(this.getLocation(), readingEffect);
            }
        }
        if ((rw & 2) != 0) {
            Type writingEffect = this.relation.getWritingEffect();
            if (writingEffect == null) {
                context.getErrorLog().log(this.getLocation(), "Relation does not support writing.");
            } else {
                context.declareEffect(this.getLocation(), writingEffect);
            }
        }
        TVar[] typeVariables = this.relation.getTypeVariables();
        this.typeParameters = new Type[typeVariables.length];
        int i = 0;
        while (i < typeVariables.length) {
            this.typeParameters[i] = Types.metaVar(typeVariables[i].getKind());
            ++i;
        }
        TPred[] typeConstraints = this.relation.getTypeConstraints();
        this.typeConstraintEvidences = new Expression[typeConstraints.length];
        int i2 = 0;
        while (i2 < typeConstraints.length) {
            EVariable demand = new EVariable(this.getLocation(), null);
            demand.setType(typeConstraints[i2].replace(typeVariables, this.typeParameters));
            context.addConstraintDemand(demand);
            this.typeConstraintEvidences[i2] = demand;
            ++i2;
        }
        Type[] parameterTypes = this.relation.getParameterTypes();
        int i3 = 0;
        while (i3 < this.parameters.length) {
            this.parameters[i3] = this.parameters[i3].checkType(context, parameterTypes[i3].replace(typeVariables, this.typeParameters));
            ++i3;
        }
    }

    public void simplify(SimplificationContext context) {
        int i = 0;
        while (i < this.typeConstraintEvidences.length) {
            this.typeConstraintEvidences[i] = this.typeConstraintEvidences[i].simplify(context);
            ++i;
        }
        i = 0;
        while (i < this.parameters.length) {
            this.parameters[i] = this.parameters[i].simplify(context);
            ++i;
        }
    }

    public void flatten(ArrayList<Variable> unknowns, TObjectIntHashMap<Variable> variableIdMap, ArrayList<QueryConstraint> constraints) {
        constraints.add(new RelationConstraint(this.typeParameters, this.typeConstraintEvidences, this.relation, this.parameters, variableIdMap));
    }

    public Expression generateEnforce(SimplificationContext context) {
        Variable[] variables = new Variable[this.parameters.length];
        int i = 0;
        while (i < variables.length) {
            variables[i] = this.parameters[i] instanceof EVariable ? ((EVariable)this.parameters[i]).getVariable() : new Variable("temp", this.parameters[i].getType());
            ++i;
        }
        Expression result = this.relation.generateEnforce(context, this.typeParameters, this.typeConstraintEvidences, variables);
        int i2 = variables.length - 1;
        while (i2 >= 0) {
            if (!(this.parameters[i2] instanceof EVariable)) {
                result = new ESimpleLet(variables[i2], this.parameters[i2], result);
            }
            --i2;
        }
        return result;
    }
}

