/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.query.pre;

import java.util.Arrays;
import org.simantics.scl.compiler.codegen.values.BooleanConstant;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EEntityTypeAnnotation;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLet;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.java.CheckRelation;
import org.simantics.scl.compiler.elaboration.query.QAtom;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.query.pre.PreQuery;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.elaboration.relations.composite.TransitiveClosureRelation;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;

public class QPreGuard
extends PreQuery {
    public Expression guard;

    public QPreGuard(Expression guard) {
        this.guard = guard;
    }

    private static QAtom resolveAsQuery(TranslationContext context, Expression function, Expression[] parameters) {
        if (function instanceof EVar) {
            String relationName = ((EVar)function).name;
            if (relationName.equals("tc") && parameters.length > 0) {
                QAtom query = QPreGuard.resolveAsQuery(context, parameters[0], Arrays.copyOfRange(parameters, 1, parameters.length));
                if (query == null) {
                    return null;
                }
                query.relation = new TransitiveClosureRelation(query.relation);
                return query;
            }
            SCLRelation relation = context.resolveRelation(function.getLocation(), relationName);
            if (relation != null) {
                int i = 0;
                while (i < parameters.length) {
                    parameters[i] = parameters[i].resolve(context);
                    ++i;
                }
                return new QAtom(relation, parameters);
            }
        }
        return null;
    }

    private static QAtom resolveAsQuery(TranslationContext context, Expression expression) {
        if (expression instanceof EApply) {
            EApply apply = (EApply)expression;
            QAtom query = QPreGuard.resolveAsQuery(context, apply.getFunction(), apply.getParameters());
            if (query != null) {
                return query;
            }
        } else if (expression instanceof EEntityTypeAnnotation) {
            expression = new ESimpleLet(new Variable("_"), expression, new ELiteral(new BooleanConstant(true)));
        }
        return new QAtom((SCLRelation)CheckRelation.INSTANCE, expression.resolve(context));
    }

    @Override
    public Query resolve(TranslationContext context) {
        PreQuery oldPreQuery = context.currentPreQuery;
        context.currentPreQuery = this;
        QAtom query = QPreGuard.resolveAsQuery(context, this.guard);
        context.currentPreQuery = oldPreQuery;
        query.location = this.location;
        return this.withSideQueries(query);
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.guard.setLocationDeep(loc);
        }
    }
}

