/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.query.compilation;

import java.util.Arrays;
import org.simantics.scl.compiler.elaboration.query.compilation.DynamicProgrammingOrdering;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryConstraint;

public class TestOrdering {
    public static void main(String[] args) throws Exception {
        QueryConstraint[] constraints = new QueryConstraint[]{new Stat(1.0, 100.0, 0, 1), new Stat(1.0, 100.0, 0, 2), new Stat(20.0, 20.0, 1, 2)};
        DynamicProgrammingOrdering.order(constraints, 1L);
        QueryConstraint[] queryConstraintArray = constraints;
        int n = constraints.length;
        int n2 = 0;
        while (n2 < n) {
            QueryConstraint constraint = queryConstraintArray[n2];
            System.out.println(constraint);
            ++n2;
        }
    }

    static class Stat
    extends QueryConstraint {
        double backwardBranching;
        double forwardBranching;
        long aMask;
        long bMask;

        public Stat(double backwardBranching, double forwardBranching, int a, int b) {
            super(new int[]{a, b});
            this.backwardBranching = backwardBranching;
            this.forwardBranching = forwardBranching;
            this.aMask = 1 << a;
            this.bMask = 1 << b;
        }

        @Override
        public boolean canBeSolvedFrom(long consumed) {
            return (consumed & this.aMask) != 0L || (consumed & this.bMask) != 0L;
        }

        @Override
        public long variablesNeededToProduce(long produced) {
            long needed = 0L;
            if ((produced & this.aMask) != 0L) {
                needed |= this.bMask;
            }
            if ((produced & this.bMask) != 0L) {
                needed |= this.aMask;
            }
            return needed;
        }

        public String toString() {
            return "Stat" + Arrays.toString(this.variables);
        }

        @Override
        public double getSolutionBranching(long consumed) {
            switch ((int)this.globalToLocal(consumed)) {
                case 1: {
                    return this.forwardBranching;
                }
                case 2: {
                    return this.backwardBranching;
                }
                case 3: {
                    return 0.95;
                }
            }
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public double getSolutionCost(long consumed) {
            return 1.0;
        }
    }
}

