/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.query.compilation;

import gnu.trove.TIntCollection;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.query.QAtom;
import org.simantics.scl.compiler.elaboration.query.compilation.ConstraintCollectionContext;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryCompilationContext;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryConstraint;

public class RelationConstraint
extends QueryConstraint {
    QAtom atom;
    int[] requiredVariables;
    int[] optionalVariableByParameter;
    long requiredVariablesMask;

    public RelationConstraint(QAtom atom, ConstraintCollectionContext context) {
        this.atom = atom;
        TIntHashSet requiredVariablesSet = new TIntHashSet();
        this.optionalVariableByParameter = new int[atom.parameters.length];
        int i = 0;
        while (i < atom.parameters.length) {
            Expression parameter = atom.parameters[i];
            if (parameter instanceof EVariable) {
                Variable variable = ((EVariable)parameter).getVariable();
                this.optionalVariableByParameter[i] = context.getVariableMap().get((Object)variable);
            } else {
                parameter.collectVars(context.getVariableMap(), requiredVariablesSet);
                this.optionalVariableByParameter[i] = -1;
            }
            ++i;
        }
        int[] nArray = this.requiredVariables = requiredVariablesSet.toArray();
        int n = this.requiredVariables.length;
        int parameter = 0;
        while (parameter < n) {
            int v = nArray[parameter];
            this.requiredVariablesMask |= (long)(1 << v);
            ++parameter;
        }
        TIntHashSet allVariablesSet = new TIntHashSet((TIntCollection)requiredVariablesSet);
        int[] nArray2 = this.optionalVariableByParameter;
        int n2 = this.optionalVariableByParameter.length;
        n = 0;
        while (n < n2) {
            int v = nArray2[n];
            if (v >= 0) {
                allVariablesSet.add(v);
            }
            ++n;
        }
        this.variables = allVariablesSet.toArray();
    }

    @Override
    public boolean canBeSolvedFrom(long boundVariables) {
        return this.getSolutionBranching(boundVariables) != Double.POSITIVE_INFINITY;
    }

    @Override
    public double getSolutionBranching(long boundVariables) {
        if ((boundVariables & this.requiredVariablesMask) != this.requiredVariablesMask) {
            return Double.POSITIVE_INFINITY;
        }
        return this.atom.relation.getSelectivity(this.getLocalBoundVariables(boundVariables));
    }

    @Override
    public long variablesNeededToProduce(long produced) {
        return this.requiredVariablesMask;
    }

    @Override
    public double getSolutionCost(long boundVariables) {
        return 1.0;
    }

    @Override
    public void generate(QueryCompilationContext context) {
        Expression parameter;
        Variable[] variables = new Variable[this.atom.parameters.length];
        int i = 0;
        while (i < this.atom.parameters.length) {
            parameter = this.atom.parameters[i];
            variables[i] = parameter instanceof EVariable ? ((EVariable)parameter).getVariable() : new Variable("temp", parameter.getType());
            ++i;
        }
        this.atom.relation.generate(context, this.atom.typeParameters, this.atom.typeConstraintEvidences, variables, this.getLocalBoundVariables(this.finalBoundVariables));
        i = this.atom.parameters.length - 1;
        while (i >= 0) {
            parameter = this.atom.parameters[i];
            if (!(parameter instanceof EVariable)) {
                context.let(variables[i], parameter);
            }
            --i;
        }
    }

    private int getLocalBoundVariables(long boundVariables) {
        int localBoundVariables = 0;
        int i = 0;
        while (i < this.optionalVariableByParameter.length) {
            int v = this.optionalVariableByParameter[i];
            if (v < 0 || (boundVariables >> v & 1L) != 0L) {
                localBoundVariables |= 1 << i;
            }
            ++i;
        }
        return localBoundVariables;
    }

    public String toString() {
        return String.valueOf(this.atom.toString()) + " requires:" + Arrays.toString(this.requiredVariables) + " optional:" + Arrays.toString(this.optionalVariableByParameter);
    }
}

