/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.query.compilation;

import org.simantics.scl.compiler.elaboration.query.compilation.QueryCompilationContext;

public abstract class QueryConstraint {
    public int[] variables;
    public long finalBoundVariables;

    public QueryConstraint(int[] variables) {
        this.variables = variables;
    }

    public QueryConstraint() {
    }

    public long getVariableMask() {
        long result = 0L;
        int[] nArray = this.variables;
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            int v = nArray[n2];
            result |= (long)(1 << v);
            ++n2;
        }
        return result;
    }

    public long globalToLocal(long global) {
        long local = 0L;
        int i = 0;
        while (i < this.variables.length) {
            if ((global >> this.variables[i] & 1L) != 0L) {
                local |= (long)(1 << i);
            }
            ++i;
        }
        return local;
    }

    public long localToGlobal(long local) {
        long global = 0L;
        int i = 0;
        while (local != 0L) {
            if ((local & 1L) != 0L) {
                global |= (long)(1 << this.variables[i]);
            }
            ++i;
            local >>= 1;
        }
        return global;
    }

    public abstract boolean canBeSolvedFrom(long var1);

    public abstract long variablesNeededToProduce(long var1);

    public abstract double getSolutionCost(long var1);

    public abstract double getSolutionBranching(long var1);

    public void generate(QueryCompilationContext context) {
    }

    public void generateAndUpdateCost(QueryCompilationContext context) {
        this.generate(context);
        context.updateCost(this.getSolutionBranching(this.finalBoundVariables), this.getSolutionCost(this.finalBoundVariables));
    }
}

