/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.query.compilation;

import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.procedure.TLongObjectProcedure;
import java.util.Iterator;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryConstraint;
import org.simantics.scl.compiler.elaboration.relations.compilation.UnsolvableQueryException;

public class DynamicProgrammingOrdering {
    int variableCount;
    QueryConstraint[] constraints;
    TLongObjectHashMap<Entry> entries = new TLongObjectHashMap();

    private DynamicProgrammingOrdering(QueryConstraint[] constraints) {
        this.constraints = constraints;
        int maxVariable = -1;
        QueryConstraint[] queryConstraintArray = constraints;
        int n = constraints.length;
        int n2 = 0;
        while (n2 < n) {
            QueryConstraint constraint = queryConstraintArray[n2];
            int[] nArray = constraint.variables;
            int n3 = constraint.variables.length;
            int n4 = 0;
            while (n4 < n3) {
                int v = nArray[n4];
                maxVariable = Math.max(maxVariable, v);
                ++n4;
            }
            ++n2;
        }
        this.variableCount = maxVariable + 1;
    }

    private void run(long initialVariableBindings) throws UnsolvableQueryException {
        this.entries.put(0L, (Object)new Entry(1.0, 0.0, null, initialVariableBindings));
        int i = 0;
        while (i < this.constraints.length) {
            this.nextEntries();
            ++i;
        }
        if (!this.entries.isEmpty()) {
            Entry entry = (Entry)this.entries.valueCollection().iterator().next();
            if (entry.path != null) {
                entry.path.updateOrder(this.constraints);
            }
        } else {
            throw new UnsolvableQueryException();
        }
        this.updateFinalBoundVariables(initialVariableBindings);
    }

    private void updateFinalBoundVariables(long boundVariables) {
        QueryConstraint[] queryConstraintArray = this.constraints;
        int n = this.constraints.length;
        int n2 = 0;
        while (n2 < n) {
            QueryConstraint constraint = queryConstraintArray[n2];
            constraint.finalBoundVariables = boundVariables;
            boundVariables |= constraint.getVariableMask();
            ++n2;
        }
    }

    private void nextEntries() {
        TLongObjectHashMap<Entry> oldEntries = this.entries;
        this.entries = new TLongObjectHashMap();
        oldEntries.forEachEntry((TLongObjectProcedure)new TLongObjectProcedure<Entry>(){

            public boolean execute(long constraintPattern, Entry entry) {
                double branching = entry.branching;
                double cost = entry.cost;
                Path path = entry.path;
                long variables = entry.variables;
                int i = 0;
                while (i < DynamicProgrammingOrdering.this.constraints.length) {
                    QueryConstraint constraint;
                    if ((constraintPattern >> i & 1L) == 0L && (constraint = DynamicProgrammingOrdering.this.constraints[i]).canBeSolvedFrom(variables)) {
                        long newConstraintPattern = constraintPattern | (long)(1 << i);
                        double newBranching = constraint.getSolutionBranching(variables) * branching;
                        double newCost = constraint.getSolutionCost(variables) * branching + cost;
                        Entry newEntry = (Entry)DynamicProgrammingOrdering.this.entries.get(newConstraintPattern);
                        if (newEntry == null) {
                            DynamicProgrammingOrdering.this.entries.put(newConstraintPattern, (Object)new Entry(newBranching, newCost, new Path(constraint, path), variables | constraint.getVariableMask()));
                        } else {
                            if (newBranching < newEntry.branching) {
                                newEntry.branching = newBranching;
                            }
                            if (newCost < newEntry.cost) {
                                newEntry.cost = newCost;
                                newEntry.path = new Path(constraint, path);
                            }
                        }
                    }
                    ++i;
                }
                return true;
            }
        });
        if (this.entries.isEmpty()) {
            System.out.println("Solved:");
            Iterator iterator = oldEntries.valueCollection().iterator();
            if (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                System.out.print("    variables:");
                long variables = entry.variables;
                int i = 0;
                while (variables != 0L) {
                    if ((variables & 1L) == 1L) {
                        System.out.print(" " + i);
                    }
                    ++i;
                    variables >>= 1;
                }
                System.out.println();
            }
        }
    }

    public static void order(QueryConstraint[] constraints, long initialVariableBindings) throws UnsolvableQueryException {
        DynamicProgrammingOrdering algorithm = new DynamicProgrammingOrdering(constraints);
        algorithm.run(initialVariableBindings);
    }

    private static class Entry {
        double branching;
        double cost;
        Path path;
        long variables;

        public Entry(double branching, double cost, Path path, long variables) {
            this.branching = branching;
            this.cost = cost;
            this.path = path;
            this.variables = variables;
        }
    }

    private static class Path {
        public final QueryConstraint constraint;
        public final Path prev;

        public Path(QueryConstraint constraint, Path prev) {
            this.constraint = constraint;
            this.prev = prev;
        }

        public void updateOrder(QueryConstraint[] constraints) {
            Path path = this;
            int i = constraints.length - 1;
            while (i >= 0) {
                constraints[i] = path.constraint;
                --i;
                path = path.prev;
            }
        }
    }
}

