/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.query;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Set;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.StandardExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.query.QAtom;
import org.simantics.scl.compiler.elaboration.query.QDisjunction;
import org.simantics.scl.compiler.elaboration.query.QueryVisitor;
import org.simantics.scl.compiler.elaboration.query.compilation.ConstraintCollectionContext;
import org.simantics.scl.compiler.elaboration.query.compilation.DerivateException;
import org.simantics.scl.compiler.elaboration.query.compilation.DynamicProgrammingOrdering;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryCompilationContext;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryConstraint;
import org.simantics.scl.compiler.elaboration.relations.CompositeRelation;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.elaboration.relations.compilation.UnsolvableQueryException;
import org.simantics.scl.compiler.parsing.Symbol;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.util.TypeUnparsingContext;

public abstract class Query
extends Symbol {
    public static final Query[] EMPTY_ARRAY = new Query[0];
    public static final int R = 1;
    public static final int W = 2;
    public static final int RW = 3;
    protected static final TIntObjectHashMap<ArrayList<Query>> NO_DERIVATE = new TIntObjectHashMap();
    public static final Diff[] NO_DIFF = new Diff[0];
    public static final QDisjunction EMPTY_QUERY = new QDisjunction(new Query[0]);

    public abstract void collectFreeVariables(THashSet<Variable> var1);

    public abstract void collectRefs(TObjectIntHashMap<SCLValue> var1, TIntHashSet var2);

    public abstract void collectVars(TObjectIntHashMap<Variable> var1, TIntHashSet var2);

    public abstract void collectEffects(int var1, THashSet<Type> var2);

    public abstract void checkType(TypingContext var1);

    public abstract Query simplify(SimplificationContext var1);

    public Query resolve(TranslationContext context) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + " does not support resolve.");
    }

    public Type getEffect(int rw) {
        THashSet effects = new THashSet();
        this.collectEffects(rw, (THashSet<Type>)effects);
        return Types.union((Type[])effects.toArray((Object[])new Type[effects.size()]));
    }

    public Expression generateEnforce(SimplificationContext context) {
        context.getErrorLog().log(this.location, String.valueOf(this.getClass().getSimpleName()) + " does not support enforcing.");
        return new EError(this.location);
    }

    public abstract void collectConstraints(ConstraintCollectionContext var1) throws UnsolvableQueryException;

    protected QueryConstraint[] getOrderedConstraints(QueryCompilationContext context) throws UnsolvableQueryException {
        ConstraintCollectionContext collectionContext = new ConstraintCollectionContext(context);
        this.collectConstraints(collectionContext);
        QueryConstraint[] constraints = collectionContext.getConstraints();
        DynamicProgrammingOrdering.order(constraints, 0L);
        return constraints;
    }

    protected void applyConstraints(QueryCompilationContext context, QueryConstraint[] constraints) {
        int i = constraints.length - 1;
        while (i >= 0) {
            constraints[i].generateAndUpdateCost(context);
            --i;
        }
    }

    public void generate(QueryCompilationContext context) throws UnsolvableQueryException {
        this.applyConstraints(context, this.getOrderedConstraints(context));
    }

    public Diff[] derivate(THashMap<SCLRelation, Diffable> diffables) throws DerivateException {
        throw new DerivateException(this.location);
    }

    public Query removeRelations(Set<SCLRelation> relations) {
        throw new UnsupportedOperationException();
    }

    public Query copy() {
        return this.replace(new ReplaceContext());
    }

    public abstract Query replace(ReplaceContext var1);

    public String toString() {
        return this.toString(new TypeUnparsingContext());
    }

    public String toString(TypeUnparsingContext tuc) {
        StringBuilder b = new StringBuilder();
        this.toString(b, tuc);
        return b.toString();
    }

    protected void toString(StringBuilder b, TypeUnparsingContext tuc) {
        b.append(this.getClass().getSimpleName());
    }

    public abstract void setLocationDeep(long var1);

    public abstract void accept(QueryVisitor var1);

    public void collectRelationRefs(final TObjectIntHashMap<SCLRelation> allRefs, final TIntHashSet refs) {
        this.accept(new StandardExpressionVisitor(){

            @Override
            public void visit(QAtom query) {
                this.visit(query.relation);
            }

            private void visit(SCLRelation relation) {
                int id = allRefs.get((Object)relation);
                if (id >= 0) {
                    refs.add(id);
                } else if (relation instanceof CompositeRelation) {
                    SCLRelation[] sCLRelationArray = ((CompositeRelation)relation).getSubrelations();
                    int n = sCLRelationArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SCLRelation subrelation = sCLRelationArray[n2];
                        this.visit(subrelation);
                        ++n2;
                    }
                }
            }
        });
    }

    public static class Diff {
        public int id;
        public Query query;

        public Diff(int id, Query query) {
            this.id = id;
            this.query = query;
        }
    }

    public static class Diffable {
        public int id;
        SCLRelation relation;
        public Variable[] parameters;

        public Diffable(int id, SCLRelation relation, Variable[] parameters) {
            this.id = id;
            this.relation = relation;
            this.parameters = parameters;
        }
    }
}

