/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.query;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.query.QAbstractModifier;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.query.QueryVisitor;
import org.simantics.scl.compiler.elaboration.query.compilation.ConstraintCollectionContext;
import org.simantics.scl.compiler.elaboration.query.compilation.DerivateException;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryCompilationContext;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryConstraint;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.elaboration.relations.compilation.UnsolvableQueryException;
import org.simantics.scl.types.Type;

public class QNegation
extends QAbstractModifier {
    public QNegation(Query query) {
        super(query);
    }

    @Override
    public void collectConstraints(ConstraintCollectionContext context) throws UnsolvableQueryException {
        TIntHashSet vars = new TIntHashSet();
        this.query.collectVars(context.getVariableMap(), vars);
        final QueryCompilationContext innerContext = context.getQueryCompilationContext().createCheckContext();
        this.query.generate(innerContext);
        context.addConstraint(new QueryConstraint(vars.toArray()){
            long variableMask;
            {
                super($anonymous0);
                int[] nArray = this.variables;
                int n = this.variables.length;
                int n2 = 0;
                while (n2 < n) {
                    int v = nArray[n2];
                    this.variableMask |= 1L << v;
                    ++n2;
                }
            }

            @Override
            public long variablesNeededToProduce(long produced) {
                return this.variableMask;
            }

            @Override
            public double getSolutionCost(long boundVariables) {
                return innerContext.getCost();
            }

            @Override
            public double getSolutionBranching(long boundVariables) {
                return innerContext.getBranching();
            }

            @Override
            public boolean canBeSolvedFrom(long boundVariables) {
                return (boundVariables & this.variableMask) == this.variableMask;
            }

            @Override
            public long getVariableMask() {
                return this.variableMask;
            }

            @Override
            public void generate(QueryCompilationContext context) {
                context.condition(new EApply(context.getConstant(Name.create("Prelude", "not"), Type.EMPTY_ARRAY), innerContext.getContinuation()));
            }
        });
    }

    @Override
    public Query replace(ReplaceContext context) {
        return new QNegation(this.query.replace(context));
    }

    @Override
    public Query.Diff[] derivate(THashMap<SCLRelation, Query.Diffable> diffables) throws DerivateException {
        Query.Diff[] diffs = this.query.derivate(diffables);
        if (diffs.length == 0) {
            return NO_DIFF;
        }
        throw new DerivateException(this.location);
    }

    @Override
    public void accept(QueryVisitor visitor) {
        visitor.visit(this);
    }
}

