/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.query;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Set;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLambda;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLet;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.query.QAbstractCombiner;
import org.simantics.scl.compiler.elaboration.query.QExists;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.query.QueryVisitor;
import org.simantics.scl.compiler.elaboration.query.compilation.ConstraintCollectionContext;
import org.simantics.scl.compiler.elaboration.query.compilation.DerivateException;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryCompilationContext;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryConstraint;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.elaboration.relations.compilation.UnsolvableQueryException;
import org.simantics.scl.types.Types;

public class QDisjunction
extends QAbstractCombiner {
    public QDisjunction(Query ... queries) {
        super(queries);
    }

    @Override
    public void collectConstraints(final ConstraintCollectionContext context) {
        TIntHashSet vars = new TIntHashSet();
        this.collectVars(context.getVariableMap(), vars);
        final Variable continuationFunction = new Variable("continuation");
        int[] variables = vars.toArray();
        long variableMask_ = 0L;
        int[] nArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            int v = nArray[n2];
            variableMask_ |= 1L << v;
            ++n2;
        }
        final long variableMask = variableMask_;
        context.addConstraint(new QueryConstraint(variables){
            TLongObjectHashMap<CachedPlan> cache;
            {
                super($anonymous0);
                this.cache = new TLongObjectHashMap();
            }

            private CachedPlan create(long boundVariables) {
                QueryCompilationContext[] subplans = new QueryCompilationContext[QDisjunction.this.queries.length];
                double totalBranching = 1.0;
                double totalCost = 0.0;
                ArrayList<Variable> solvedVariablesList = new ArrayList<Variable>();
                int[] nArray = this.variables;
                int n = this.variables.length;
                int n2 = 0;
                while (n2 < n) {
                    int v = nArray[n2];
                    if ((boundVariables >> v & 1L) == 0L) {
                        solvedVariablesList.add(context.getVariable(v));
                    }
                    ++n2;
                }
                Variable[] solvedVariables = solvedVariablesList.toArray(new Variable[solvedVariablesList.size()]);
                int i = 0;
                while (i < QDisjunction.this.queries.length) {
                    Expression[] parameters = new Expression[solvedVariables.length];
                    int j = 0;
                    while (j < solvedVariables.length) {
                        parameters[j] = new EVariable(solvedVariables[j]);
                        ++j;
                    }
                    EApply cont = new EApply(9223372034707292160L, Types.PROC, (Expression)new EVariable(continuationFunction), parameters);
                    cont.setType(context.getQueryCompilationContext().getContinuation().getType());
                    subplans[i] = context.getQueryCompilationContext().createSubcontext(cont);
                    try {
                        new QExists(solvedVariables, QDisjunction.this.queries[i]).generate(subplans[i]);
                    }
                    catch (UnsolvableQueryException e) {
                        return new CachedPlan(null, null, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                    }
                    totalBranching += subplans[i].getBranching();
                    totalCost += subplans[i].getCost();
                    ++i;
                }
                return new CachedPlan(solvedVariables, subplans, totalBranching, totalCost);
            }

            private CachedPlan get(long boundVariables) {
                CachedPlan plan = (CachedPlan)this.cache.get(boundVariables &= variableMask);
                if (plan == null) {
                    plan = this.create(boundVariables);
                    this.cache.put(boundVariables, (Object)plan);
                }
                return plan;
            }

            @Override
            public long variablesNeededToProduce(long produced) {
                return 0L;
            }

            @Override
            public double getSolutionCost(long boundVariables) {
                return this.get((long)boundVariables).totalCost;
            }

            @Override
            public double getSolutionBranching(long boundVariables) {
                return this.get((long)boundVariables).totalBranching;
            }

            @Override
            public boolean canBeSolvedFrom(long boundVariables) {
                return this.get((long)boundVariables).totalCost != Double.POSITIVE_INFINITY;
            }

            @Override
            public void generate(QueryCompilationContext context2) {
                CachedPlan plan = this.get(this.finalBoundVariables);
                Expression[] disjuncts = new Expression[plan.subplans.length];
                int i = 0;
                while (i < plan.subplans.length) {
                    disjuncts[i] = plan.subplans[i].getContinuation().copy();
                    ++i;
                }
                Expression result = context2.disjunction(disjuncts);
                ReplaceContext replaceContext = new ReplaceContext();
                Variable[] newVariables = new Variable[plan.variables.length];
                int i2 = 0;
                while (i2 < newVariables.length) {
                    Variable newVariable;
                    Variable oldVariable = plan.variables[i2];
                    newVariables[i2] = newVariable = new Variable(oldVariable.getName(), oldVariable.getType());
                    oldVariable.setName(String.valueOf(oldVariable.getName()) + "_temp");
                    replaceContext.varMap.put((Object)oldVariable, (Object)new EVariable(newVariable));
                    ++i2;
                }
                Expression functionDefinition = context2.getContinuation().replace(replaceContext);
                boolean first = true;
                int i3 = plan.variables.length - 1;
                while (i3 >= 0) {
                    functionDefinition = new ESimpleLambda(first ? Types.PROC : Types.NO_EFFECTS, newVariables[i3], functionDefinition);
                    first = false;
                    --i3;
                }
                continuationFunction.setType(functionDefinition.getType());
                context2.setContinuation(new ESimpleLet(continuationFunction, functionDefinition, result));
            }
        });
    }

    @Override
    public Query.Diff[] derivate(THashMap<SCLRelation, Query.Diffable> diffables) throws DerivateException {
        Query.Diff[][] diffs = new Query.Diff[this.queries.length][];
        int totalDiffCount = 0;
        int i = 0;
        while (i < this.queries.length) {
            Query.Diff[] ds = this.queries[i].derivate(diffables);
            diffs[i] = ds;
            totalDiffCount += ds.length;
            ++i;
        }
        if (totalDiffCount == 0) {
            return NO_DIFF;
        }
        Query.Diff[] result = new Query.Diff[totalDiffCount];
        int i2 = 0;
        Query.Diff[][] diffArrayArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            Query.Diff[] ds;
            Query.Diff[] diffArray = ds = diffArrayArray[n2];
            int n3 = ds.length;
            int n4 = 0;
            while (n4 < n3) {
                Query.Diff diff = diffArray[n4];
                result[i2++] = diff;
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    @Override
    public Query replace(ReplaceContext context) {
        Query[] newQueries = new Query[this.queries.length];
        int i = 0;
        while (i < this.queries.length) {
            newQueries[i] = this.queries[i].replace(context);
            ++i;
        }
        return new QDisjunction(newQueries);
    }

    @Override
    public Query removeRelations(Set<SCLRelation> relations) {
        int i = 0;
        while (i < this.queries.length) {
            Query query = this.queries[i];
            Query newQuery = query.removeRelations(relations);
            if (query != newQuery) {
                ArrayList<Query> newQueries = new ArrayList<Query>(this.queries.length);
                int j = 0;
                while (j < i) {
                    newQueries.add(this.queries[j]);
                    ++j;
                }
                if (newQuery != EMPTY_QUERY) {
                    newQueries.add(newQuery);
                }
                ++i;
                while (i < this.queries.length) {
                    query = this.queries[i];
                    newQuery = query.removeRelations(relations);
                    if (newQuery != EMPTY_QUERY) {
                        newQueries.add(newQuery);
                    }
                    ++i;
                }
                if (newQueries.isEmpty()) {
                    return EMPTY_QUERY;
                }
                if (newQueries.size() == 1) {
                    return (Query)newQueries.get(0);
                }
                return new QDisjunction(newQueries.toArray(new Query[newQueries.size()]));
            }
            ++i;
        }
        return this;
    }

    @Override
    public void accept(QueryVisitor visitor) {
        visitor.visit(this);
    }

    private static class CachedPlan {
        Variable[] variables;
        QueryCompilationContext[] subplans;
        double totalBranching;
        double totalCost;

        public CachedPlan(Variable[] variables, QueryCompilationContext[] subplans, double totalBranching, double totalCost) {
            this.variables = variables;
            this.subplans = subplans;
            this.totalBranching = totalBranching;
            this.totalCost = totalCost;
        }
    }
}

