/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.query;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Set;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLet;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.java.EqRelation;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.query.QConjunction;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.query.QueryVisitor;
import org.simantics.scl.compiler.elaboration.query.compilation.ConstraintCollectionContext;
import org.simantics.scl.compiler.elaboration.query.compilation.DerivateException;
import org.simantics.scl.compiler.elaboration.query.compilation.RelationConstraint;
import org.simantics.scl.compiler.elaboration.relations.CompositeRelation;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.types.TPred;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class QAtom
extends Query {
    public SCLRelation relation;
    public Type[] typeParameters;
    public Expression[] typeConstraintEvidences;
    public Expression[] parameters;

    public QAtom(SCLRelation relation, Expression ... parameters) {
        this.relation = relation;
        this.parameters = parameters;
    }

    public QAtom(SCLRelation relation, Type[] typeParameters, Expression[] typeConstraintEvidences, Expression ... parameters) {
        this.relation = relation;
        this.typeParameters = typeParameters;
        this.typeConstraintEvidences = typeConstraintEvidences;
        this.parameters = parameters;
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        Expression[] expressionArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Expression parameter = expressionArray[n2];
            parameter.collectFreeVariables(vars);
            ++n2;
        }
        if (this.typeConstraintEvidences != null) {
            expressionArray = this.typeConstraintEvidences;
            n = this.typeConstraintEvidences.length;
            n2 = 0;
            while (n2 < n) {
                Expression evidence = expressionArray[n2];
                evidence.collectFreeVariables(vars);
                ++n2;
            }
        }
    }

    @Override
    public void collectEffects(int rw, THashSet<Type> effects) {
        Expression[] expressionArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Expression parameter = expressionArray[n2];
            parameter.collectEffects(effects);
            ++n2;
        }
        if ((rw & 1) != 0) {
            effects.add((Object)this.relation.getReadingEffect());
        }
        if ((rw & 2) != 0) {
            effects.add((Object)this.relation.getWritingEffect());
        }
    }

    @Override
    public void checkType(TypingContext context) {
        TVar[] typeVariables = this.relation.getTypeVariables();
        this.typeParameters = new Type[typeVariables.length];
        int i = 0;
        while (i < typeVariables.length) {
            this.typeParameters[i] = Types.metaVar(typeVariables[i].getKind());
            ++i;
        }
        TPred[] typeConstraints = this.relation.getTypeConstraints();
        this.typeConstraintEvidences = new Expression[typeConstraints.length];
        int i2 = 0;
        while (i2 < typeConstraints.length) {
            EVariable demand = new EVariable(this.getLocation(), null);
            demand.setType(typeConstraints[i2].replace(typeVariables, this.typeParameters));
            context.addConstraintDemand(demand);
            this.typeConstraintEvidences[i2] = demand;
            ++i2;
        }
        Type[] parameterTypes = this.relation.getParameterTypes();
        int i3 = 0;
        while (i3 < this.parameters.length) {
            this.parameters[i3] = this.parameters[i3].checkType(context, parameterTypes[i3].replace(typeVariables, this.typeParameters));
            ++i3;
        }
    }

    @Override
    public Expression generateEnforce(SimplificationContext context) {
        Variable[] variables = new Variable[this.parameters.length];
        int i = 0;
        while (i < variables.length) {
            variables[i] = this.parameters[i] instanceof EVariable ? ((EVariable)this.parameters[i]).getVariable() : new Variable("temp", this.parameters[i].getType());
            ++i;
        }
        Expression result = this.relation.generateEnforce(context, this.typeParameters, this.typeConstraintEvidences, variables);
        int i2 = variables.length - 1;
        while (i2 >= 0) {
            if (!(this.parameters[i2] instanceof EVariable)) {
                result = new ESimpleLet(variables[i2], this.parameters[i2], result);
            }
            --i2;
        }
        return result;
    }

    @Override
    public void collectConstraints(ConstraintCollectionContext context) {
        context.addConstraint(new RelationConstraint(this, context));
    }

    @Override
    public void collectRefs(TObjectIntHashMap<SCLValue> allRefs, TIntHashSet refs) {
        Expression[] expressionArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Expression parameter = expressionArray[n2];
            parameter.collectRefs(allRefs, refs);
            ++n2;
        }
        if (this.typeConstraintEvidences != null) {
            expressionArray = this.typeConstraintEvidences;
            n = this.typeConstraintEvidences.length;
            n2 = 0;
            while (n2 < n) {
                Expression evidence = expressionArray[n2];
                evidence.collectRefs(allRefs, refs);
                ++n2;
            }
        }
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        Expression[] expressionArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Expression parameter = expressionArray[n2];
            parameter.collectVars(allVars, vars);
            ++n2;
        }
        if (this.typeConstraintEvidences != null) {
            expressionArray = this.typeConstraintEvidences;
            n = this.typeConstraintEvidences.length;
            n2 = 0;
            while (n2 < n) {
                Expression evidence = expressionArray[n2];
                evidence.collectVars(allVars, vars);
                ++n2;
            }
        }
    }

    @Override
    public Query simplify(SimplificationContext context) {
        int i = 0;
        while (i < this.typeConstraintEvidences.length) {
            this.typeConstraintEvidences[i] = this.typeConstraintEvidences[i].simplify(context);
            ++i;
        }
        i = 0;
        while (i < this.parameters.length) {
            this.parameters[i] = this.parameters[i].simplify(context);
            ++i;
        }
        return this;
    }

    @Override
    public Query replace(ReplaceContext context) {
        Type[] newTypeParameters = new Type[this.typeParameters.length];
        int i = 0;
        while (i < this.typeParameters.length) {
            newTypeParameters[i] = this.typeParameters[i].replace(context.tvarMap);
            ++i;
        }
        return new QAtom(this.relation, newTypeParameters, Expression.replace(context, this.typeConstraintEvidences), Expression.replace(context, this.parameters));
    }

    @Override
    protected void toString(StringBuilder b, TypeUnparsingContext tuc) {
        b.append(this.relation);
        Expression[] expressionArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Expression parameter = expressionArray[n2];
            b.append(' ');
            parameter.toString(b, tuc);
            ++n2;
        }
    }

    @Override
    public Query.Diff[] derivate(THashMap<SCLRelation, Query.Diffable> diffables) throws DerivateException {
        Query.Diffable diffable = (Query.Diffable)diffables.get((Object)this.relation);
        if (diffable == null) {
            if (this.relation instanceof CompositeRelation && QAtom.containsReferenceTo((CompositeRelation)this.relation, diffables)) {
                throw new DerivateException(this.location);
            }
            return NO_DIFF;
        }
        Query[] eqs = new Query[this.parameters.length];
        int i = 0;
        while (i < this.parameters.length) {
            QAtom eq = new QAtom((SCLRelation)EqRelation.INSTANCE, new EVariable(diffable.parameters[i]), this.parameters[i]);
            eq.typeConstraintEvidences = Expression.EMPTY_ARRAY;
            eq.typeParameters = new Type[]{this.parameters[i].getType()};
            eqs[i] = eq;
            ++i;
        }
        return new Query.Diff[]{new Query.Diff(diffable.id, new QConjunction(eqs))};
    }

    private static boolean containsReferenceTo(CompositeRelation relation, THashMap<SCLRelation, Query.Diffable> diffables) {
        SCLRelation[] sCLRelationArray = relation.getSubrelations();
        int n = sCLRelationArray.length;
        int n2 = 0;
        while (n2 < n) {
            SCLRelation r = sCLRelationArray[n2];
            if (diffables.containsKey((Object)r)) {
                return true;
            }
            if (r instanceof CompositeRelation && QAtom.containsReferenceTo((CompositeRelation)r, diffables)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Query removeRelations(Set<SCLRelation> relations) {
        if (relations.contains(this.relation)) {
            return EMPTY_QUERY;
        }
        return this;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            Expression[] expressionArray = this.parameters;
            int n = this.parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Expression parameter = expressionArray[n2];
                parameter.setLocationDeep(loc);
                ++n2;
            }
            if (this.typeConstraintEvidences != null) {
                expressionArray = this.typeConstraintEvidences;
                n = this.typeConstraintEvidences.length;
                n2 = 0;
                while (n2 < n) {
                    Expression evidence = expressionArray[n2];
                    evidence.setLocationDeep(loc);
                    ++n2;
                }
            }
        }
    }

    @Override
    public void accept(QueryVisitor visitor) {
        visitor.visit(this);
    }
}

