/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.modules;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.scl.compiler.codegen.effects.EffectConstructor;
import org.simantics.scl.compiler.codegen.types.TypeConstructor;
import org.simantics.scl.compiler.codegen.values.Constant;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.macros.MacroRule;
import org.simantics.scl.compiler.elaboration.modules.Documentation;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.Module;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.TypeAlias;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.elaboration.modules.TypeClassInstance;
import org.simantics.scl.compiler.elaboration.relations.SCLEntityType;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.elaboration.resolving.Resolver;
import org.simantics.scl.compiler.parsing.declarations.DImportAst;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;

public class ConcreteModule
extends Environment
implements Module {
    String moduleName;
    THashMap<String, TypeConstructor> typeConstructors = new THashMap();
    THashMap<String, TypeAlias> typeAliases = new THashMap();
    THashMap<String, EffectConstructor> effectConstructors = new THashMap();
    THashMap<String, TypeClass> typeClasses = new THashMap();
    THashMap<TCon, ArrayList<TypeClassInstance>> typeClassInstances = new THashMap();
    THashMap<String, SCLValue> values = new THashMap();
    THashMap<String, SCLRelation> relations = new THashMap();
    THashMap<String, SCLEntityType> entityTypes = new THashMap();
    ArrayList<DImportAst> dependencies = new ArrayList();
    protected Documentation documentation;
    private transient Resolver resolver = new Resolver(){

        @Override
        public TCon getType(String name) {
            if (ConcreteModule.this.typeConstructors.containsKey((Object)name)) {
                return Types.con(ConcreteModule.this.moduleName, name);
            }
            return null;
        }

        @Override
        public TCon getClass(String name) {
            if (ConcreteModule.this.typeClasses.containsKey((Object)name)) {
                return Types.con(ConcreteModule.this.moduleName, name);
            }
            return null;
        }

        @Override
        public Name getValue(String name) {
            if (ConcreteModule.this.values.containsKey((Object)name)) {
                return Name.create(ConcreteModule.this.moduleName, name);
            }
            return null;
        }

        @Override
        public Name getRelation(String name) {
            if (ConcreteModule.this.relations.containsKey((Object)name)) {
                return Name.create(ConcreteModule.this.moduleName, name);
            }
            return null;
        }

        @Override
        public Name getEntityType(String name) {
            if (ConcreteModule.this.entityTypes.containsKey((Object)name)) {
                return Name.create(ConcreteModule.this.moduleName, name);
            }
            return null;
        }

        @Override
        public void findValuesForPrefix(final Collection<SCLValue> values, final String prefix) {
            ConcreteModule.this.values.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<String, SCLValue>(){

                public boolean execute(String name, SCLValue value) {
                    String lowerPrefix = prefix.toLowerCase();
                    String lowerName = name.toLowerCase();
                    if (lowerName.startsWith(lowerPrefix)) {
                        values.add(value);
                    }
                    return true;
                }
            });
        }

        @Override
        public TCon getEffect(String name) {
            if (ConcreteModule.this.effectConstructors.containsKey((Object)name)) {
                return Types.con(ConcreteModule.this.moduleName, name);
            }
            return null;
        }

        public String toString() {
            return ConcreteModule.this.moduleName;
        }

        @Override
        public TCon getTypeAlias(String name) {
            TypeAlias alias = (TypeAlias)ConcreteModule.this.typeAliases.get((Object)name);
            if (alias == null) {
                return null;
            }
            return alias.con;
        }
    };

    public ConcreteModule(String moduleName) {
        this.moduleName = moduleName;
    }

    public boolean addTypeConstructor(String name, TypeConstructor typeConstructor) {
        return this.typeConstructors.put((Object)name, (Object)typeConstructor) != null;
    }

    public boolean addTypeAlias(String name, TypeAlias alias) {
        return this.typeAliases.put((Object)name, (Object)alias) != null;
    }

    public boolean addEffectConstructor(String name, EffectConstructor effectConstructor) {
        return this.effectConstructors.put((Object)name, (Object)effectConstructor) != null;
    }

    public boolean addTypeClass(String name, TypeClass typeClass) {
        return this.typeClasses.put((Object)name, (Object)typeClass) != null;
    }

    public void addTypeClassInstance(TCon typeClass, TypeClassInstance typeClassInstance) {
        ArrayList<TypeClassInstance> instances = (ArrayList<TypeClassInstance>)this.typeClassInstances.get((Object)typeClass);
        if (instances == null) {
            instances = new ArrayList<TypeClassInstance>();
            this.typeClassInstances.put((Object)typeClass, instances);
        }
        instances.add(typeClassInstance);
    }

    public Collection<TCon> getTypeClassesWithInstances() {
        return this.typeClassInstances.keySet();
    }

    public boolean addValue(SCLValue value) {
        return this.values.put((Object)value.getName().name, (Object)value) != null;
    }

    public SCLValue addValue(String name, Constant constant) {
        SCLValue value = new SCLValue(Name.create(this.moduleName, name), constant);
        this.addValue(value);
        return value;
    }

    public void addRelation(String name, SCLRelation relation) {
        this.relations.put((Object)name, (Object)relation);
    }

    public void addEntityType(String name, SCLEntityType entityType) {
        this.entityTypes.put((Object)name, (Object)entityType);
    }

    public SCLValue addMacro(String name, Type type, MacroRule rule) {
        SCLValue value = new SCLValue(Name.create(this.moduleName, name));
        value.setType(type);
        value.setMacroRule(rule);
        this.addValue(value);
        return value;
    }

    public void addDependency(DImportAst module) {
        if (!this.dependencies.contains(module)) {
            this.dependencies.add(module);
        }
    }

    public Collection<SCLValue> getValues() {
        return this.values.values();
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public Environment getEnvironment() {
        return this;
    }

    @Override
    public Resolver getResolver() {
        return this.resolver;
    }

    public SCLValue getValue(String name) {
        return (SCLValue)this.values.get((Object)name);
    }

    @Override
    public SCLValue getValue(Name name) {
        return (SCLValue)this.values.get((Object)name.name);
    }

    public SCLRelation getRelation(String name) {
        return (SCLRelation)this.relations.get((Object)name);
    }

    @Override
    public SCLRelation getRelation(Name name) {
        return (SCLRelation)this.relations.get((Object)name.name);
    }

    public SCLEntityType getEntityType(String name) {
        return (SCLEntityType)this.entityTypes.get((Object)name);
    }

    @Override
    public SCLEntityType getEntityType(Name name) {
        return (SCLEntityType)this.entityTypes.get((Object)name.name);
    }

    @Override
    public TypeClass getTypeClass(TCon name) {
        return (TypeClass)this.typeClasses.get((Object)name.name);
    }

    public TypeClass getTypeClass(String name) {
        return (TypeClass)this.typeClasses.get((Object)name);
    }

    @Override
    public Collection<TypeClassInstance> getInstances(TCon typeClass) {
        Collection result = (Collection)this.typeClassInstances.get((Object)typeClass);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    @Override
    public TypeConstructor getTypeConstructor(TCon type) {
        return (TypeConstructor)this.typeConstructors.get((Object)type.name);
    }

    @Override
    public EffectConstructor getEffectConstructor(TCon type) {
        return (EffectConstructor)this.effectConstructors.get((Object)type.name);
    }

    public Collection<TypeClass> getTypeClasses() {
        return this.typeClasses.values();
    }

    public THashMap<TCon, ArrayList<TypeClassInstance>> getTypeInstances() {
        return this.typeClassInstances;
    }

    @Override
    public Collection<DImportAst> getDependencies() {
        return this.dependencies;
    }

    public void setDocumentation(Documentation documentation) {
        this.documentation = documentation;
    }

    @Override
    public Documentation getDocumentation() {
        return this.documentation;
    }

    public TypeAlias getTypeAlias(String name) {
        return (TypeAlias)this.typeAliases.get((Object)name);
    }

    @Override
    public TypeAlias getTypeAlias(TCon con) {
        return (TypeAlias)this.typeAliases.get((Object)con.name);
    }
}

