/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.modules;

import java.util.Collection;
import java.util.Collections;
import org.simantics.scl.compiler.elaboration.modules.CompositeEnvironment;
import org.simantics.scl.compiler.elaboration.modules.Documentation;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.Module;
import org.simantics.scl.compiler.elaboration.resolving.CompositeResolver;
import org.simantics.scl.compiler.elaboration.resolving.Resolver;
import org.simantics.scl.compiler.parsing.declarations.DImportAst;
import org.simantics.scl.compiler.top.ModuleLoader;
import org.simantics.scl.compiler.top.NotFoundException;

public class CompositeModule
implements Module {
    ModuleLoader moduleLoader;
    CompositeEnvironment environment = new CompositeEnvironment();
    CompositeResolver resolver = new CompositeResolver();

    public CompositeModule(ModuleLoader moduleLoader) {
        this.moduleLoader = moduleLoader;
    }

    @Override
    public String getModuleName() {
        return "Composite";
    }

    @Override
    public Resolver getResolver() {
        return this.resolver;
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    public void add(String namespace, Module[] modules) {
        Module[] moduleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            Module module = moduleArray[n2];
            this.add(namespace, module);
            ++n2;
        }
    }

    public void add(String namespace, Module module) {
        if (namespace != null) {
            this.resolver.addModule(namespace, module);
        }
        if (this.environment.addModule(module)) {
            for (DImportAst dependency : module.getDependencies()) {
                if (!this.environment.containsModule(dependency.moduleName)) {
                    this.add(null, dependency.moduleName);
                }
                if (dependency.localName == null || namespace == null) continue;
                Module newModule = (Module)((Object)this.environment.getModule(dependency.moduleName));
                String newNamespace = namespace.isEmpty() ? dependency.localName : (dependency.localName.isEmpty() ? namespace : String.valueOf(namespace) + "." + dependency.localName);
                this.resolver.addModule(newNamespace, newModule);
            }
        }
    }

    public void add(String namespace, String moduleName) throws NotFoundException {
        Module module = this.moduleLoader.loadModule(moduleName);
        if (module == null) {
            throw new NotFoundException("Couldn't find module " + moduleName + ".");
        }
        this.add(namespace, module);
    }

    @Override
    public Collection<DImportAst> getDependencies() {
        return Collections.emptyList();
    }

    @Override
    public Documentation getDocumentation() {
        return null;
    }
}

