/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.modules;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import java.util.ArrayList;
import java.util.Collection;
import org.simantics.scl.compiler.codegen.effects.EffectConstructor;
import org.simantics.scl.compiler.codegen.types.TypeConstructor;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.Module;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.TypeAlias;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.elaboration.modules.TypeClassInstance;
import org.simantics.scl.compiler.elaboration.relations.SCLEntityType;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.types.TCon;

public class CompositeEnvironment
extends Environment {
    THashMap<String, Environment> components = new THashMap();

    public boolean addEnvironment(String moduleName, Environment module) {
        return this.components.put((Object)moduleName, (Object)module) == null;
    }

    public boolean addModule(Module module) {
        return this.addEnvironment(module.getModuleName(), module.getEnvironment());
    }

    protected Environment getModule(String name) {
        return (Environment)this.components.get((Object)name);
    }

    @Override
    public TypeClass getTypeClass(TCon name) {
        Environment env = this.getModule(name.module);
        if (env == null) {
            return null;
        }
        return env.getTypeClass(name);
    }

    @Override
    public TypeConstructor getTypeConstructor(TCon type) {
        Environment module = this.getModule(type.module);
        if (module == null) {
            return null;
        }
        return module.getTypeConstructor(type);
    }

    @Override
    public EffectConstructor getEffectConstructor(TCon type) {
        Environment module = this.getModule(type.module);
        if (module == null) {
            return null;
        }
        return module.getEffectConstructor(type);
    }

    @Override
    public Collection<TypeClassInstance> getInstances(TCon typeClass) {
        ArrayList<TypeClassInstance> result = new ArrayList<TypeClassInstance>();
        for (Environment env : this.components.values()) {
            result.addAll(env.getInstances(typeClass));
        }
        return result;
    }

    @Override
    public SCLValue getValue(Name name) {
        Environment module = this.getModule(name.module);
        if (module == null) {
            return null;
        }
        return module.getValue(name);
    }

    @Override
    public SCLRelation getRelation(Name name) {
        Environment module = this.getModule(name.module);
        if (module == null) {
            return null;
        }
        return module.getRelation(name);
    }

    @Override
    public SCLEntityType getEntityType(Name name) {
        Environment module = this.getModule(name.module);
        if (module == null) {
            return null;
        }
        return module.getEntityType(name);
    }

    public boolean containsModule(String module) {
        return this.components.containsKey((Object)module);
    }

    public String toString() {
        final StringBuilder b = new StringBuilder();
        this.components.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<String, Environment>(){

            public boolean execute(String name, Environment env) {
                b.append("    <").append(name).append(">\n");
                return true;
            }
        });
        return b.toString();
    }

    @Override
    public TypeAlias getTypeAlias(TCon con) {
        Environment module = this.getModule(con.module);
        if (module == null) {
            return null;
        }
        return module.getTypeAlias(con);
    }
}

