/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.matching;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.List;
import org.simantics.scl.compiler.codegen.continuations.Branch;
import org.simantics.scl.compiler.codegen.continuations.ICont;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.types.TypeConstructor;
import org.simantics.scl.compiler.codegen.values.Constant;
import org.simantics.scl.compiler.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EApplyType;
import org.simantics.scl.compiler.elaboration.expressions.EAsPattern;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EExternalConstant;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.GuardedExpressionGroup;
import org.simantics.scl.compiler.elaboration.matching.Row;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.util.Typed;

public class PatternMatchingCompiler {
    public static IVal[] replace(IVal[] vals, int columnToReplace, IVal ... substitution) {
        IVal[] newVals = new IVal[vals.length - 1 + substitution.length];
        int j = 0;
        int i = 0;
        while (i < columnToReplace) {
            newVals[j++] = vals[i];
            ++i;
        }
        i = 0;
        while (i < substitution.length) {
            newVals[j++] = substitution[i];
            ++i;
        }
        i = columnToReplace + 1;
        while (i < vals.length) {
            newVals[j++] = vals[i];
            ++i;
        }
        return newVals;
    }

    private static void split(CodeWriter w, Environment env, IVal[] scrutinee, ICont success, ICont failure, List<Row> rows, int columnId) {
        THashMap matrixMap = new THashMap();
        ArrayList<Branch> branches = new ArrayList<Branch>();
        ArrayList<ExpressionMatrix> matrices = new ArrayList<ExpressionMatrix>();
        int i = 0;
        while (i < rows.size()) {
            CodeWriter newW;
            ExpressionMatrix matrix;
            Typed constructor;
            Expression applyConstructor;
            Row row = rows.get(i);
            Expression pattern = row.patterns[columnId];
            while (true) {
                if (pattern instanceof EApplyType) {
                    pattern = ((EApplyType)pattern).getExpression();
                } else {
                    if (!(pattern instanceof EAsPattern)) break;
                    EAsPattern asPattern = (EAsPattern)pattern;
                    pattern = asPattern.getPattern();
                    asPattern.getVar().setVal(scrutinee[columnId]);
                }
                row.patterns[columnId] = pattern;
            }
            if (pattern instanceof EVariable) break;
            if (pattern instanceof EApply) {
                applyConstructor = (EApply)pattern;
                Expression constructor_ = ((EApply)applyConstructor).getFunction();
                while (constructor_ instanceof EApplyType) {
                    constructor_ = ((EApplyType)constructor_).getExpression();
                }
                SCLValue constructor2 = ((EConstant)constructor_).getValue();
                Typed[] parameters = ((EApply)applyConstructor).getParameters();
                ExpressionMatrix matrix2 = (ExpressionMatrix)matrixMap.get((Object)constructor2.getName());
                if (matrix2 == null) {
                    CodeWriter newW2 = w.createBlock(Types.getTypes(parameters));
                    branches.add(new Branch((Constant)constructor2.getValue(), newW2.getContinuation()));
                    matrix2 = new ExpressionMatrix(newW2, PatternMatchingCompiler.replace(scrutinee, columnId, newW2.getParameters()));
                    matrices.add(matrix2);
                    matrixMap.put((Object)constructor2.getName(), (Object)matrix2);
                }
                matrix2.rows.add(row.replace(columnId, (Expression[])parameters));
            } else if (pattern instanceof EConstant) {
                applyConstructor = (EConstant)pattern;
                constructor = ((EConstant)applyConstructor).getValue();
                matrix = (ExpressionMatrix)matrixMap.get((Object)((SCLValue)constructor).getName());
                if (matrix == null) {
                    newW = w.createBlock(new Type[0]);
                    branches.add(new Branch((Constant)((SCLValue)constructor).getValue(), newW.getContinuation()));
                    matrix = new ExpressionMatrix(newW, PatternMatchingCompiler.replace(scrutinee, columnId, newW.getParameters()));
                    matrices.add(matrix);
                    matrixMap.put((Object)((SCLValue)constructor).getName(), (Object)matrix);
                }
                matrix.rows.add(row.replace(columnId, Expression.EMPTY_ARRAY));
            } else if (pattern instanceof ELiteral) {
                ELiteral literal = (ELiteral)pattern;
                constructor = literal.getValue();
                matrix = (ExpressionMatrix)matrixMap.get((Object)constructor);
                if (matrix == null) {
                    newW = w.createBlock(new Type[0]);
                    branches.add(new Branch((Constant)constructor, newW.getContinuation()));
                    matrix = new ExpressionMatrix(newW, PatternMatchingCompiler.replace(scrutinee, columnId, newW.getParameters()));
                    matrices.add(matrix);
                    matrixMap.put((Object)constructor, (Object)matrix);
                }
                matrix.rows.add(row.replace(columnId, Expression.EMPTY_ARRAY));
            } else if (pattern instanceof EExternalConstant) {
                EExternalConstant constant = (EExternalConstant)pattern;
                constructor = w.getModuleWriter().getExternalConstant(constant.getValue(), constant.getType());
                matrix = (ExpressionMatrix)matrixMap.get((Object)constructor);
                if (matrix == null) {
                    newW = w.createBlock(new Type[0]);
                    branches.add(new Branch((Constant)constructor, newW.getContinuation()));
                    matrix = new ExpressionMatrix(newW, PatternMatchingCompiler.replace(scrutinee, columnId, newW.getParameters()));
                    matrices.add(matrix);
                    matrixMap.put((Object)constructor, (Object)matrix);
                }
                matrix.rows.add(row.replace(columnId, Expression.EMPTY_ARRAY));
            } else {
                throw new InternalCompilerError("Cannot handle an instance of " + pattern.getClass().getSimpleName() + " in a pattern.");
            }
            ++i;
        }
        if (i < rows.size()) {
            CodeWriter newW = w.createBlock(new Type[0]);
            ICont cont = newW.getContinuation();
            branches.add(new Branch(null, cont));
            PatternMatchingCompiler.split(newW, env, scrutinee, success, failure, rows.subList(i, rows.size()));
            failure = cont;
        } else {
            int maxBranchCount;
            TCon con;
            try {
                con = Types.getConstructor(scrutinee[columnId].getType());
            }
            catch (MatchException e) {
                throw new InternalCompilerError();
            }
            TypeConstructor cons = env.getTypeConstructor(con);
            int n = maxBranchCount = cons.isOpen ? Integer.MAX_VALUE : cons.constructors.length;
            if (branches.size() < maxBranchCount) {
                branches.add(new Branch(null, failure));
            }
        }
        for (ExpressionMatrix mx : matrices) {
            PatternMatchingCompiler.split(mx.w, env, mx.scrutinee, success, failure, mx.rows);
        }
        w.switch_(scrutinee[columnId], branches.toArray(new Branch[branches.size()]));
    }

    public static void split(CodeWriter w, Environment env, IVal[] scrutinee, ICont success, ICont failure, List<Row> rows) {
        Row firstRow = rows.get(0);
        Expression[] patterns = firstRow.patterns;
        if (scrutinee.length != patterns.length) {
            throw new InternalCompilerError();
        }
        int i = 0;
        while (i < patterns.length) {
            if (!(patterns[i] instanceof EVariable)) {
                PatternMatchingCompiler.split(w, env, scrutinee, success, failure, rows, i);
                return;
            }
            ++i;
        }
        i = 0;
        while (i < patterns.length) {
            ((EVariable)patterns[i]).getVariable().setVal(scrutinee[i]);
            ++i;
        }
        if (firstRow.value instanceof GuardedExpressionGroup) {
            GuardedExpressionGroup group = (GuardedExpressionGroup)firstRow.value;
            if (rows.size() == 1) {
                group.compile(env, w, success, failure);
            } else {
                CodeWriter newW = w.createBlock(new Type[0]);
                ICont cont = newW.getContinuation();
                group.compile(env, w, success, cont);
                PatternMatchingCompiler.split(newW, env, scrutinee, success, failure, rows.subList(1, rows.size()));
            }
        } else {
            w.jump(success, firstRow.value.toVal(env, w));
        }
    }

    private static class ExpressionMatrix {
        final CodeWriter w;
        final IVal[] scrutinee;
        final List<Row> rows = new ArrayList<Row>();

        public ExpressionMatrix(CodeWriter w, IVal[] scrutinee) {
            this.w = w;
            this.scrutinee = scrutinee;
        }
    }
}

