/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.macros;

import gnu.trove.map.hash.THashMap;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.ELambda;
import org.simantics.scl.compiler.elaboration.expressions.ELambdaType;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLambda;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.macros.MacroRule;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;

public class StandardMacroRule
implements MacroRule {
    Expression baseExpression;
    int arity;

    public void setBaseExpression(Expression baseExpression) {
        this.baseExpression = baseExpression;
        Expression cur = baseExpression;
        while (true) {
            Expression lambda;
            if (cur instanceof ELambdaType) {
                cur = ((ELambdaType)cur).value;
                continue;
            }
            if (cur instanceof ELambda) {
                lambda = (ELambda)cur;
                this.arity += ((ELambda)lambda).getCases()[0].getPatterns().length;
                break;
            }
            if (!(cur instanceof ESimpleLambda)) break;
            lambda = (ESimpleLambda)cur;
            cur = ((ESimpleLambda)lambda).value;
            ++this.arity;
        }
    }

    @Override
    public Expression apply(SimplificationContext context, Type[] typeParameters, EApply apply) {
        if (apply.getParameters().length < this.arity) {
            return null;
        }
        THashMap tvarMap = new THashMap();
        THashMap varMap = new THashMap();
        Expression baseExpr = this.baseExpression;
        int typeParameterId = 0;
        while (typeParameterId < typeParameters.length) {
            ELambdaType lambda = (ELambdaType)baseExpr;
            TVar[] tVarArray = lambda.parameters;
            int n = lambda.parameters.length;
            int n2 = 0;
            while (n2 < n) {
                TVar var = tVarArray[n2];
                tvarMap.put((Object)var, (Object)typeParameters[typeParameterId++]);
                ++n2;
            }
            baseExpr = lambda.value;
        }
        Expression[] expressionArray = apply.getParameters();
        int n = expressionArray.length;
        int n3 = 0;
        while (n3 < n) {
            Expression parameter = expressionArray[n3];
            if (baseExpr instanceof ELambda) {
                baseExpr = ((ELambda)baseExpr).decomposeMatching();
            }
            ESimpleLambda lambda = (ESimpleLambda)baseExpr;
            varMap.put((Object)lambda.parameter, (Object)parameter);
            baseExpr = lambda.value;
            ++n3;
        }
        baseExpr = baseExpr.replace(new ReplaceContext((THashMap<TVar, Type>)tvarMap, (THashMap<Variable, Expression>)varMap));
        return baseExpr;
    }
}

