/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.macros;

import java.util.Arrays;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.macros.MacroApplicationException;
import org.simantics.scl.compiler.elaboration.macros.MacroRule;
import org.simantics.scl.compiler.elaboration.macros.ParameterExtractor;
import org.simantics.scl.types.Type;

public abstract class BasicMacroRule2<T0, T1>
implements MacroRule {
    public static int ARITY = 2;
    ParameterExtractor<T0> extractor0;
    ParameterExtractor<T1> extractor1;

    public BasicMacroRule2(ParameterExtractor<T0> extractor0, ParameterExtractor<T1> extractor1) {
        this.extractor0 = extractor0;
        this.extractor1 = extractor1;
    }

    @Override
    public Expression apply(SimplificationContext context, Type[] typeParameters, EApply apply) {
        Expression[] parameters = apply.getParameters();
        if (parameters.length < ARITY) {
            return null;
        }
        T0 p0 = this.extractor0.extract(context, parameters[0]);
        T1 p1 = this.extractor1.extract(context, parameters[1]);
        if (p0 == null || p1 == null) {
            return null;
        }
        try {
            Expression result = this.apply(context, typeParameters, p0, p1);
            if (parameters.length > ARITY) {
                apply.set(result, Arrays.copyOfRange(parameters, ARITY, parameters.length));
                return apply;
            }
            return result;
        }
        catch (MacroApplicationException e) {
            context.getErrorLog().log(apply.location, e.getMessage());
            return null;
        }
    }

    public abstract Expression apply(SimplificationContext var1, Type[] var2, T0 var3, T1 var4) throws MacroApplicationException;
}

