/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.macros;

import java.util.Arrays;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.macros.MacroRule;
import org.simantics.scl.types.Type;

public abstract class BasicMacroRule
implements MacroRule {
    int arity;

    public BasicMacroRule(int arity) {
        this.arity = arity;
    }

    @Override
    public Expression apply(SimplificationContext context, Type[] typeParameters, EApply apply) {
        Expression[] parameters = apply.getParameters();
        if (parameters.length < this.arity) {
            return null;
        }
        if (parameters.length == this.arity) {
            return this.apply(context, typeParameters, parameters);
        }
        Expression result = this.apply(context, typeParameters, Arrays.copyOf(parameters, this.arity));
        if (result == null) {
            return null;
        }
        apply.set(result, Arrays.copyOfRange(parameters, this.arity, parameters.length));
        return apply;
    }

    public abstract Expression apply(SimplificationContext var1, Type[] var2, Expression[] var3);
}

