/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.java;

import java.util.Arrays;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.types.JavaReferenceValidator;
import org.simantics.scl.compiler.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.codegen.utils.Constants;
import org.simantics.scl.compiler.codegen.values.JavaStaticMethod;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.java.JavaModule;
import org.simantics.scl.compiler.elaboration.macros.BasicMacroRule1;
import org.simantics.scl.compiler.elaboration.macros.MacroApplicationException;
import org.simantics.scl.compiler.elaboration.macros.StringExtractor;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.util.MultiFunction;

public final class StaticMethodMacroRule
extends BasicMacroRule1<String> {
    public StaticMethodMacroRule() {
        super(StringExtractor.INSTANCE);
    }

    @Override
    public Expression apply(SimplificationContext context, Type[] typeParameters, String fullMethodName) throws MacroApplicationException {
        int maxArity;
        int p = fullMethodName.lastIndexOf(46);
        if (p == -1) {
            throw new MacroApplicationException("Invalid method name. Didn't contain class name.");
        }
        String className = fullMethodName.substring(0, p);
        String methodName = fullMethodName.substring(p + 1, fullMethodName.length());
        JavaReferenceValidator<Object, Object, Object, Object> validator = context.getJavaReferenceValidator();
        Object clazz = validator.findClass(TypeDesc.forClass((String)className));
        if (clazz == null) {
            throw new MacroApplicationException("Didn't find class " + className + ".");
        }
        JavaTypeTranslator translator = context.getJavaTypeTranslator();
        MultiFunction mfun = Types.matchFunction(typeParameters[0]);
        int arity = maxArity = mfun.parameterTypes.length;
        while (arity >= 0) {
            TypeDesc constrainingReturnType;
            TypeDesc[] constrainingParameterTypes = JavaTypeTranslator.filterVoid(translator.toTypeDescs(Arrays.copyOf(mfun.parameterTypes, arity)));
            Object[] methods = validator.findCompatibleMethods(clazz, true, methodName, constrainingParameterTypes, constrainingReturnType = arity < maxArity ? Constants.FUNCTION : translator.toTypeDesc(mfun.returnType));
            if (methods.length != 0) {
                if (methods.length > 1 && (methods = validator.chooseBest((Object[])methods)).length > 1) {
                    throw new MacroApplicationException("Ambigious reference to a static method " + methodName + " of type " + typeParameters[0] + " from class " + className + ".");
                }
                Object method = methods[0];
                TypeDesc returnType = validator.getReturnType(method);
                TypeDesc[] parameterTypes = validator.getParameterTypes(method);
                Type[] ps = Arrays.copyOf(mfun.parameterTypes, arity);
                Type ret = mfun.returnType;
                Type effect = mfun.effect;
                int i = maxArity - 1;
                while (i >= arity) {
                    ret = Types.functionE(mfun.parameterTypes[i], effect, ret);
                    effect = Types.NO_EFFECTS;
                    --i;
                }
                return JavaModule.createLiteral(new JavaStaticMethod(className, methodName, effect, returnType, parameterTypes, ret, ps));
            }
            --arity;
        }
        throw new MacroApplicationException("Didn't find a public static method " + methodName + " of type " + typeParameters[0] + " from class " + className + ".");
    }
}

