/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.java;

import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.types.JavaReferenceValidator;
import org.simantics.scl.compiler.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.codegen.values.JavaStaticField;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.expressions.EApplyType;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.macros.BasicMacroRule1;
import org.simantics.scl.compiler.elaboration.macros.MacroApplicationException;
import org.simantics.scl.compiler.elaboration.macros.StringExtractor;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;

public final class StaticFieldMacroRule
extends BasicMacroRule1<String> {
    public StaticFieldMacroRule() {
        super(StringExtractor.INSTANCE);
    }

    @Override
    public Expression apply(SimplificationContext context, Type[] typeParameters, String fullMethodName) throws MacroApplicationException {
        int p = fullMethodName.lastIndexOf(46);
        if (p == -1) {
            throw new MacroApplicationException("Invalid field name. Didn't contain class name.");
        }
        String className = fullMethodName.substring(0, p);
        String fieldName = fullMethodName.substring(p + 1, fullMethodName.length());
        JavaTypeTranslator translator = context.getJavaTypeTranslator();
        JavaReferenceValidator<Object, Object, Object, Object> validator = context.getJavaReferenceValidator();
        Object clazz = validator.findClass(TypeDesc.forClass((String)className));
        if (clazz == null) {
            throw new MacroApplicationException("Didn't find class " + className + ".");
        }
        Object field = validator.findField(clazz, fieldName);
        if (field == null) {
            throw new MacroApplicationException("Didn't find a public field " + fieldName + " from class " + className + ".");
        }
        if (!validator.isStaticField(field)) {
            throw new MacroApplicationException("Field " + fieldName + " from class " + className + " is not static.");
        }
        Type type = typeParameters[0];
        TypeDesc fieldType = validator.getFieldType(field);
        TypeDesc expectedType = translator.toTypeDesc(type);
        if (!validator.isAssignableFrom(expectedType, fieldType)) {
            throw new MacroApplicationException("Type of the field " + fieldName + " from class " + className + " does not match with the expected type " + type + ".");
        }
        Type[] tvs = Types.freeVarsArray(type);
        return EApplyType.create(new ELiteral(new JavaStaticField(className, fieldName, Types.NO_EFFECTS, fieldType, Types.forAll((TVar[])tvs, type))), tvs);
    }
}

