/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.java;

import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.values.FunctionValue;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.kinds.Kinds;

public class SetMVector
extends FunctionValue {
    private static final TVar A = Types.var(Kinds.STAR);
    public static final SetMVector INSTANCE = new SetMVector();

    private SetMVector() {
        super(new TVar[]{A}, Types.PROC, Types.UNIT, Types.mvector(A), Types.INTEGER, A);
    }

    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        Val vector = parameters[0];
        Val index = parameters[1];
        Val value = parameters[2];
        vector.push(mb);
        index.push(mb);
        try {
            Type elementType = Types.canonical(Types.matchApply(Types.MVECTOR, vector.getType()));
            CodeBuilder cb = mb.getCodeBuilder();
            if (elementType instanceof TVar) {
                mb.push(value, elementType);
                cb.invokeStatic("java.lang.reflect.Array", "set", TypeDesc.VOID, new TypeDesc[]{TypeDesc.OBJECT, TypeDesc.INT, TypeDesc.OBJECT});
                return Types.UNIT;
            }
            value.push(mb);
            TypeDesc desc = mb.getJavaTypeTranslator().toTypeDesc(elementType);
            cb.storeToArray(desc);
            return Types.UNIT;
        }
        catch (MatchException e) {
            throw new InternalCompilerError(e);
        }
    }
}

