/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.java;

import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.types.JavaReferenceValidator;
import org.simantics.scl.compiler.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.codegen.values.JavaSetField;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.expressions.EApplyType;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.macros.BasicMacroRule1;
import org.simantics.scl.compiler.elaboration.macros.MacroApplicationException;
import org.simantics.scl.compiler.elaboration.macros.StringExtractor;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;

public final class SetFieldMacroRule
extends BasicMacroRule1<String> {
    public SetFieldMacroRule() {
        super(StringExtractor.INSTANCE);
    }

    @Override
    public Expression apply(SimplificationContext context, Type[] typeParameters, String fieldName) throws MacroApplicationException {
        TypeDesc expectedType;
        JavaTypeTranslator translator = context.getJavaTypeTranslator();
        JavaReferenceValidator<Object, Object, Object, Object> validator = context.getJavaReferenceValidator();
        TypeDesc typeDesc = translator.toTypeDesc(typeParameters[0]);
        String className = typeDesc.getFullName();
        Object clazz = validator.findClass(typeDesc);
        if (clazz == null) {
            throw new MacroApplicationException("Didn't find class " + className + ".");
        }
        Object field = validator.findField(clazz, fieldName);
        if (field == null) {
            throw new MacroApplicationException("Didn't find a public field " + fieldName + " from class " + className + ".");
        }
        if (validator.isStaticField(field)) {
            throw new MacroApplicationException("Field " + fieldName + " from class " + className + " is static.");
        }
        Type type = typeParameters[1];
        TypeDesc fieldType = validator.getFieldType(field);
        if (!validator.isAssignableFrom(fieldType, expectedType = translator.toTypeDesc(type))) {
            throw new MacroApplicationException("Type of the field " + fieldName + " from class " + className + " does not match with the expected type " + typeParameters[1] + ".");
        }
        Type[] tvs = Types.freeVarsArray(typeParameters);
        return EApplyType.create(new ELiteral(new JavaSetField(className, fieldName, (TVar[])tvs, fieldType, type, typeParameters[0])), tvs);
    }
}

