/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.java;

import java.util.Arrays;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.types.JavaReferenceValidator;
import org.simantics.scl.compiler.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.codegen.utils.Constants;
import org.simantics.scl.compiler.codegen.values.JavaMethod;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.java.JavaModule;
import org.simantics.scl.compiler.elaboration.macros.BasicMacroRule1;
import org.simantics.scl.compiler.elaboration.macros.MacroApplicationException;
import org.simantics.scl.compiler.elaboration.macros.StringExtractor;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.util.MultiFunction;

public final class MethodMacroRule
extends BasicMacroRule1<String> {
    public MethodMacroRule() {
        super(StringExtractor.INSTANCE);
    }

    @Override
    public Expression apply(SimplificationContext context, Type[] typeParameters, String methodName) throws MacroApplicationException {
        int maxArity;
        JavaTypeTranslator translator = context.getJavaTypeTranslator();
        JavaReferenceValidator<Object, Object, Object, Object> validator = context.getJavaReferenceValidator();
        MultiFunction mfun = Types.matchFunction(typeParameters[0]);
        if (mfun.parameterTypes.length == 0) {
            throw new MacroApplicationException("Must be a function.");
        }
        Type objectType = mfun.parameterTypes[0];
        TypeDesc typeDesc = translator.toTypeDesc(objectType);
        Object clazz = validator.findClass(typeDesc);
        if (clazz == null) {
            throw new MacroApplicationException("Didn't find class " + typeDesc.getFullName() + ".");
        }
        String className = typeDesc.getFullName();
        mfun.parameterTypes = Arrays.copyOfRange(mfun.parameterTypes, 1, mfun.parameterTypes.length);
        int arity = maxArity = mfun.parameterTypes.length;
        while (arity >= 0) {
            TypeDesc constrainingReturnType;
            TypeDesc[] constrainingParameterTypes = JavaTypeTranslator.filterVoid(translator.toTypeDescs(Arrays.copyOf(mfun.parameterTypes, arity)));
            Object[] methods = validator.findCompatibleMethods(clazz, false, methodName, constrainingParameterTypes, constrainingReturnType = arity < maxArity ? Constants.FUNCTION : translator.toTypeDesc(mfun.returnType));
            if (methods.length != 0) {
                if (methods.length > 1 && (methods = validator.chooseBest((Object[])methods)).length > 1) {
                    throw new MacroApplicationException("Ambigious reference to a method " + methodName + " of type " + typeParameters[0] + " from class " + className + ".");
                }
                Object method = methods[0];
                TypeDesc returnType = validator.getReturnType(method);
                TypeDesc[] parameterTypes = validator.getParameterTypes(method);
                Type[] ps = new Type[arity + 1];
                ps[0] = objectType;
                int i = 0;
                while (i < arity) {
                    ps[i + 1] = mfun.parameterTypes[i];
                    ++i;
                }
                Type ret = mfun.returnType;
                Type effect = mfun.effect;
                int i2 = maxArity - 1;
                while (i2 >= arity) {
                    ret = Types.functionE(mfun.parameterTypes[i2], effect, ret);
                    effect = Types.NO_EFFECTS;
                    --i2;
                }
                return JavaModule.createLiteral(new JavaMethod(!validator.isInterface(clazz), className, methodName, effect, returnType, parameterTypes, ret, ps));
            }
            --arity;
        }
        throw new MacroApplicationException("Didn't find a public method " + methodName + " of type " + typeParameters[1] + " from class " + className + ".");
    }
}

