/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.java;

import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.continuations.Cont;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.codegen.utils.Constants;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.values.FunctionValue;
import org.simantics.scl.compiler.codegen.values.LocalVariableConstant;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.kinds.Kinds;

class ListConstructor
extends FunctionValue {
    private static final TVar A = Types.var(Kinds.STAR);
    int arity;

    public ListConstructor(int arity) {
        super(new TVar[]{A}, Types.NO_EFFECTS, Types.list(A), ListConstructor.parameterList(arity));
        this.arity = arity;
    }

    private static Type[] parameterList(int arity) {
        Type[] parameters = new Type[arity];
        int i = 0;
        while (i < arity) {
            parameters[i] = A;
            ++i;
        }
        return parameters;
    }

    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        CodeBuilder cb = mb.getCodeBuilder();
        cb.loadConstant(this.arity);
        cb.newObject(Constants.OBJECT_ARRAY, 1);
        int i = 0;
        while (i < this.arity) {
            cb.dup();
            cb.loadConstant(i);
            mb.pushBoxed(parameters[i]);
            cb.storeToArray(TypeDesc.OBJECT);
            ++i;
        }
        cb.invokeStatic("java.util.Arrays", "asList", Constants.LIST, new TypeDesc[]{Constants.OBJECT_ARRAY});
        return this.getReturnType();
    }

    @Override
    public void deconstruct(MethodBuilder mb, IVal parameter, Cont success, Label failure) {
        if (failure == null) {
            throw new InternalCompilerError("List deconstruction may always fail");
        }
        if (success.getArity() != this.arity) {
            throw new InternalCompilerError("Arity of the list constructor (" + this.arity + ") is different from the arity of the success continuation (" + success.getArity() + ").");
        }
        CodeBuilder cb = mb.getCodeBuilder();
        parameter.push(mb);
        cb.invokeInterface(Constants.LIST, "size", TypeDesc.INT, Constants.EMPTY_TYPEDESC_ARRAY);
        cb.loadConstant(this.arity);
        cb.ifComparisonBranch((Location)failure, "!=");
        JavaTypeTranslator translator = mb.getJavaTypeTranslator();
        IVal[] parameters = new IVal[this.arity];
        int i = 0;
        while (i < this.arity) {
            parameter.push(mb);
            cb.loadConstant(i);
            cb.invokeInterface(Constants.LIST, "get", TypeDesc.OBJECT, new TypeDesc[]{TypeDesc.INT});
            try {
                mb.unbox(Types.matchApply(Types.LIST, parameter.getType()));
            }
            catch (MatchException e) {
                throw new InternalCompilerError("Expected list type.");
            }
            Type pType = success.getParameterType(i);
            TypeDesc pTypeDesc = translator.toTypeDesc(pType);
            LocalVariable lv = cb.createLocalVariable("temp", pTypeDesc);
            cb.storeLocal(lv);
            parameters[i] = new LocalVariableConstant(pType, lv);
            ++i;
        }
        mb.jump(success, parameters);
    }

    public String toString() {
        return "[...]";
    }
}

