/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.java;

import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.utils.Constants;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.values.FunctionValue;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.kinds.Kinds;

public class LengthVector
extends FunctionValue {
    private static final TVar A = Types.var(Kinds.STAR);
    private final TCon constructor;

    public LengthVector(TCon constructor) {
        super(new TVar[]{A}, Types.NO_EFFECTS, Types.INTEGER, Types.apply((Type)constructor, (Type)A));
        this.constructor = constructor;
    }

    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        Val vector = parameters[0];
        vector.push(mb);
        try {
            Type elementType = Types.canonical(Types.matchApply(this.constructor, vector.getType()));
            CodeBuilder cb = mb.getCodeBuilder();
            if (elementType instanceof TVar) {
                cb.invokeStatic("java.lang.reflect.Array", "getLength", TypeDesc.INT, Constants.OBJECTS[1]);
                return Types.INTEGER;
            }
            cb.arrayLength();
            return Types.INTEGER;
        }
        catch (MatchException e) {
            throw new InternalCompilerError(e);
        }
    }
}

