/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.java;

import org.simantics.scl.compiler.codegen.values.DoubleConstant;
import org.simantics.scl.compiler.codegen.values.FloatConstant;
import org.simantics.scl.compiler.codegen.values.FunctionValue;
import org.simantics.scl.compiler.codegen.values.IntegerConstant;
import org.simantics.scl.compiler.codegen.values.JavaComparisonOperation;
import org.simantics.scl.compiler.codegen.values.JavaComparisonToZeroOperation;
import org.simantics.scl.compiler.codegen.values.JavaConversionOperation;
import org.simantics.scl.compiler.codegen.values.JavaMathOperation;
import org.simantics.scl.compiler.codegen.values.JavaMethod;
import org.simantics.scl.compiler.codegen.values.LongConstant;
import org.simantics.scl.compiler.codegen.values.UnsafeCoerce;
import org.simantics.scl.compiler.elaboration.expressions.EApplyType;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.java.ConstructorMacroRule;
import org.simantics.scl.compiler.elaboration.java.FieldMacroRule;
import org.simantics.scl.compiler.elaboration.java.MethodMacroRule;
import org.simantics.scl.compiler.elaboration.java.StaticFieldMacroRule;
import org.simantics.scl.compiler.elaboration.java.StaticMethodMacroRule;
import org.simantics.scl.compiler.elaboration.modules.ConcreteModule;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.kinds.Kinds;

public class JavaModule
extends ConcreteModule {
    public static final JavaModule INSTANCE = new JavaModule();
    public static final String MODULE_NAME = "JavaBuiltin";

    private JavaModule() {
        super(MODULE_NAME);
        FunctionValue operation;
        this.addValue("dconst_0", new DoubleConstant(0.0));
        this.addValue("dconst_1", new DoubleConstant(1.0));
        this.addValue("fconst_0", new FloatConstant(0.0f));
        this.addValue("fconst_1", new FloatConstant(1.0f));
        this.addValue("iconst_0", new IntegerConstant(0));
        this.addValue("iconst_1", new IntegerConstant(1));
        this.addValue("lconst_0", new LongConstant(0L));
        this.addValue("lconst_1", new LongConstant(1L));
        FunctionValue[] functionValueArray = JavaMathOperation.OPCODES;
        int n = JavaMathOperation.OPCODES.length;
        int n2 = 0;
        while (n2 < n) {
            operation = functionValueArray[n2];
            this.addValue(((JavaMathOperation)operation).getMnemonic(), operation);
            ++n2;
        }
        this.addValue("cadd", JavaMathOperation.CADD);
        this.addValue("csub", JavaMathOperation.CSUB);
        functionValueArray = JavaConversionOperation.OPCODES;
        n = JavaConversionOperation.OPCODES.length;
        n2 = 0;
        while (n2 < n) {
            operation = functionValueArray[n2];
            this.addValue(((JavaConversionOperation)operation).getMnemonic(), operation);
            ++n2;
        }
        this.addValue("icmpeq", new JavaComparisonOperation("==", Types.INTEGER));
        this.addValue("icmpne", new JavaComparisonOperation("!=", Types.INTEGER));
        this.addValue("icmplt", new JavaComparisonOperation("<", Types.INTEGER));
        this.addValue("icmple", new JavaComparisonOperation("<=", Types.INTEGER));
        this.addValue("icmpgt", new JavaComparisonOperation(">", Types.INTEGER));
        this.addValue("icmpge", new JavaComparisonOperation(">=", Types.INTEGER));
        this.addValue("lcmpeq", new JavaComparisonOperation("==", Types.LONG));
        this.addValue("lcmpne", new JavaComparisonOperation("!=", Types.LONG));
        this.addValue("lcmplt", new JavaComparisonOperation("<", Types.LONG));
        this.addValue("lcmple", new JavaComparisonOperation("<=", Types.LONG));
        this.addValue("lcmpgt", new JavaComparisonOperation(">", Types.LONG));
        this.addValue("lcmpge", new JavaComparisonOperation(">=", Types.LONG));
        this.addValue("fcmpeq", new JavaComparisonOperation("==", Types.FLOAT));
        this.addValue("fcmpne", new JavaComparisonOperation("!=", Types.FLOAT));
        this.addValue("fcmplt", new JavaComparisonOperation("<", Types.FLOAT));
        this.addValue("fcmple", new JavaComparisonOperation("<=", Types.FLOAT));
        this.addValue("fcmpgt", new JavaComparisonOperation(">", Types.FLOAT));
        this.addValue("fcmpge", new JavaComparisonOperation(">=", Types.FLOAT));
        this.addValue("dcmpeq", new JavaComparisonOperation("==", Types.DOUBLE));
        this.addValue("dcmpne", new JavaComparisonOperation("!=", Types.DOUBLE));
        this.addValue("dcmplt", new JavaComparisonOperation("<", Types.DOUBLE));
        this.addValue("dcmple", new JavaComparisonOperation("<=", Types.DOUBLE));
        this.addValue("dcmpgt", new JavaComparisonOperation(">", Types.DOUBLE));
        this.addValue("dcmpge", new JavaComparisonOperation(">=", Types.DOUBLE));
        this.addValue("ccmpeq", new JavaComparisonOperation("==", Types.CHARACTER));
        this.addValue("ccmpne", new JavaComparisonOperation("!=", Types.CHARACTER));
        this.addValue("ccmplt", new JavaComparisonOperation("<", Types.CHARACTER));
        this.addValue("ccmple", new JavaComparisonOperation("<=", Types.CHARACTER));
        this.addValue("ccmpgt", new JavaComparisonOperation(">", Types.CHARACTER));
        this.addValue("ccmpge", new JavaComparisonOperation(">=", Types.CHARACTER));
        this.addValue("ifeq", new JavaComparisonToZeroOperation("=="));
        this.addValue("ifne", new JavaComparisonToZeroOperation("!="));
        this.addValue("iflt", new JavaComparisonToZeroOperation("<"));
        this.addValue("ifle", new JavaComparisonToZeroOperation("<="));
        this.addValue("ifgt", new JavaComparisonToZeroOperation(">"));
        this.addValue("ifge", new JavaComparisonToZeroOperation(">="));
        TVar A2 = Types.var(Kinds.STAR);
        TVar B = Types.var(Kinds.STAR);
        this.addValue("unsafeCoerce", UnsafeCoerce.INSTANCE);
        this.addValue("equals", new JavaMethod(true, "java.lang.Object", "equals", (Type)Types.NO_EFFECTS, (Type)Types.BOOLEAN, A2, A2));
        this.addValue("hashCode", new JavaMethod(true, "java.lang.Object", "hashCode", (Type)Types.NO_EFFECTS, (Type)Types.INTEGER, A2));
        this.addValue("toString", new JavaMethod(true, "java.lang.Object", "toString", (Type)Types.NO_EFFECTS, (Type)Types.STRING, A2));
        this.addMacro("staticMethod", Types.forAll(A2, Types.function((Type)Types.STRING, (Type)A2)), new StaticMethodMacroRule());
        this.addMacro("method", Types.forAll(A2, Types.function((Type)Types.STRING, (Type)A2)), new MethodMacroRule());
        this.addMacro("constructor", Types.forAll(A2, Types.function((Type)Types.STRING, (Type)A2)), new ConstructorMacroRule());
        this.addMacro("staticField", Types.forAll(A2, Types.function((Type)Types.STRING, (Type)A2)), new StaticFieldMacroRule());
        this.addMacro("field", Types.forAll(A2, (Type)Types.forAll(B, Types.function((Type)Types.STRING, Types.function((Type)A2, (Type)B)))), new FieldMacroRule());
    }

    static Expression createLiteral(FunctionValue value) {
        Expression result = new ELiteral(value);
        TVar[] tVarArray = value.getTypeParameters();
        int n = tVarArray.length;
        int n2 = 0;
        while (n2 < n) {
            TVar var = tVarArray[n2];
            result = new EApplyType(result, var);
            ++n2;
        }
        return result;
    }
}

