/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.java;

import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.values.FunctionValue;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.kinds.Kinds;

public class GetVector
extends FunctionValue {
    private static final TVar A = Types.var(Kinds.STAR);
    private final TCon constructor;

    public GetVector(Type effect, TCon constructor) {
        super(new TVar[]{A}, effect, A, Types.apply((Type)constructor, (Type)A), Types.INTEGER);
        this.constructor = constructor;
    }

    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        Val vector = parameters[0];
        Val index = parameters[1];
        vector.push(mb);
        index.push(mb);
        try {
            Type elementType = Types.canonical(Types.matchApply(this.constructor, vector.getType()));
            CodeBuilder cb = mb.getCodeBuilder();
            if (elementType instanceof TVar) {
                cb.invokeStatic("java.lang.reflect.Array", "get", TypeDesc.OBJECT, new TypeDesc[]{TypeDesc.OBJECT, TypeDesc.INT});
                return A;
            }
            TypeDesc desc = mb.getJavaTypeTranslator().toTypeDesc(elementType);
            cb.loadFromArray(desc);
            return elementType;
        }
        catch (MatchException e) {
            throw new InternalCompilerError(e);
        }
    }
}

