/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.java;

import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.Location;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.continuations.Cont;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.utils.Constants;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.values.Constant;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.kinds.Kinds;

public class EmptyListConstructor
extends Constant {
    private static final TVar A = Types.var(Kinds.STAR);

    public EmptyListConstructor() {
        super(Types.forAll(A, Types.list(A)));
    }

    @Override
    public void push(MethodBuilder mb) {
        mb.getCodeBuilder().loadStaticField("java.util.Collections", "EMPTY_LIST", Constants.LIST);
    }

    @Override
    public void deconstruct(MethodBuilder mb, IVal parameter, Cont success, Label failure) {
        if (failure == null) {
            throw new InternalCompilerError("List deconstruction may always fail");
        }
        CodeBuilder cb = mb.getCodeBuilder();
        parameter.push(mb);
        cb.invokeInterface(Constants.LIST, "size", TypeDesc.INT, Constants.EMPTY_TYPEDESC_ARRAY);
        cb.ifZeroComparisonBranch((Location)failure, "!=");
        mb.jump(success);
    }
}

