/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.java;

import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.utils.Constants;
import org.simantics.scl.compiler.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.codegen.values.FunctionValue;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.kinds.Kinds;

public class CreateVectorFromList
extends FunctionValue {
    private static final TVar A = Types.var(Kinds.STAR);
    public static final CreateVectorFromList INSTANCE = new CreateVectorFromList();

    private CreateVectorFromList() {
        super(new TVar[]{A}, Types.NO_EFFECTS, Types.vector(A), Types.list(A));
    }

    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        Val list = parameters[0];
        try {
            Type elementType = Types.canonical(Types.matchApply(Types.LIST, list.getType()));
            CodeBuilder cb = mb.getCodeBuilder();
            if (elementType instanceof TVar) {
                throw new InternalCompilerError("Not implemented!");
            }
            TypeDesc desc = mb.getJavaTypeTranslator().toTypeDesc(elementType);
            TypeDesc arrayDesc = desc.toArrayType();
            list.push(mb);
            cb.dup();
            LocalVariable listVar = cb.createLocalVariable("tempList", Constants.LIST);
            cb.storeLocal(listVar);
            cb.invokeInterface("java.util.List", "size", TypeDesc.INT, Constants.EMPTY_TYPEDESC_ARRAY);
            cb.dup();
            LocalVariable lengthVar = cb.createLocalVariable("tempLength", TypeDesc.INT);
            cb.storeLocal(lengthVar);
            cb.newObject(arrayDesc, 1);
            LocalVariable arrayVar = cb.createLocalVariable("tempArray", arrayDesc);
            cb.storeLocal(arrayVar);
            LocalVariable posVar = cb.createLocalVariable("tempPos", TypeDesc.INT);
            cb.loadConstant(0);
            cb.storeLocal(posVar);
            Label loopBegin = cb.createLabel();
            Label loopEnd = cb.createLabel();
            loopBegin.setLocation();
            cb.loadLocal(posVar);
            cb.loadLocal(lengthVar);
            cb.ifComparisonBranch((Location)loopEnd, "==");
            cb.loadLocal(arrayVar);
            cb.loadLocal(posVar);
            cb.loadLocal(listVar);
            cb.loadLocal(posVar);
            cb.invokeInterface("java.util.List", "get", TypeDesc.OBJECT, new TypeDesc[]{TypeDesc.INT});
            cb.checkCast(desc.toObjectType());
            if (desc.isPrimitive()) {
                cb.convert(desc.toObjectType(), desc);
            }
            cb.storeToArray(desc);
            cb.integerIncrement(posVar, 1);
            cb.branch((Location)loopBegin);
            loopEnd.setLocation();
            cb.loadLocal(arrayVar);
            return Types.vector(elementType);
        }
        catch (MatchException e) {
            throw new InternalCompilerError(e);
        }
    }
}

