/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.java;

import java.util.Arrays;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.codegen.types.JavaReferenceValidator;
import org.simantics.scl.compiler.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.codegen.values.JavaConstructor;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.java.JavaModule;
import org.simantics.scl.compiler.elaboration.macros.BasicMacroRule1;
import org.simantics.scl.compiler.elaboration.macros.MacroApplicationException;
import org.simantics.scl.compiler.elaboration.macros.StringExtractor;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.util.MultiFunction;

public final class ConstructorMacroRule
extends BasicMacroRule1<String> {
    public ConstructorMacroRule() {
        super(StringExtractor.INSTANCE);
    }

    @Override
    public Expression apply(SimplificationContext context, Type[] typeParameters, String className) throws MacroApplicationException {
        JavaTypeTranslator translator = context.getJavaTypeTranslator();
        JavaReferenceValidator<Object, Object, Object, Object> validator = context.getJavaReferenceValidator();
        Object clazz = validator.findClass(TypeDesc.forClass((String)className));
        if (clazz == null) {
            throw new MacroApplicationException("Didn't find class " + className + ".");
        }
        MultiFunction mfun = Types.matchFunction(typeParameters[0]);
        int maxArity = mfun.parameterTypes.length;
        Object[] constructors = validator.findCompatibleConstructors(clazz, translator.toTypeDescs(mfun.parameterTypes, mfun.returnType));
        if (constructors.length == 0) {
            throw new MacroApplicationException("Didn't find a public constructor of type " + typeParameters[0] + " from class " + className + ".");
        }
        if (constructors.length > 1) {
            throw new MacroApplicationException("Ambigious reference to a constructor of type " + typeParameters[0] + " from class " + className + ".");
        }
        Object constructor = constructors[0];
        TypeDesc[] parameterTypes = validator.getConstructorParameterTypes(constructor);
        int arity = parameterTypes.length;
        Type[] ps = Arrays.copyOf(mfun.parameterTypes, arity);
        Type ret = mfun.returnType;
        int i = maxArity - 1;
        while (i >= arity) {
            ret = Types.function(mfun.parameterTypes[i], ret);
            --i;
        }
        return JavaModule.createLiteral(new JavaConstructor(className, mfun.effect, parameterTypes, ret, ps));
    }
}

