/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions.list;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.list.CompiledQualifier;
import org.simantics.scl.compiler.elaboration.expressions.list.ListQualifier;
import org.simantics.scl.compiler.elaboration.expressions.list.ListQualifierVisitor;
import org.simantics.scl.compiler.elaboration.internal.ExpressionDecorator;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.types.TMetaVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.UnificationException;
import org.simantics.scl.types.kinds.Kinds;

public class ListThen
extends ListQualifier {
    public ListQualifier left;
    public Expression transformer;
    public Expression by;
    TMetaVar cType;

    public ListThen(Expression transformer, Expression by) {
        this.transformer = transformer;
        this.by = by;
    }

    public void setLeft(ListQualifier inner) {
        this.left = inner;
    }

    @Override
    public void checkType(TypingContext context) {
        this.left.checkType(context);
        this.cType = Types.metaVar(Kinds.STAR);
        Type transformerType = Types.function(Types.list(this.cType), Types.list(this.cType));
        if (this.by != null) {
            this.by = this.by.checkType(context, Types.metaVar(Kinds.STAR));
            transformerType = Types.function(Types.function((Type)this.cType, this.by.getType()), transformerType);
        }
        this.transformer = this.transformer.checkType(context, transformerType);
        if (!(Types.canonical(this.cType) instanceof TMetaVar)) {
            context.getErrorLog().log(this.location, "Transformation function must be generic on list elements.");
        }
    }

    @Override
    public void collectRefs(TObjectIntHashMap<SCLValue> allRefs, TIntHashSet refs) {
        this.left.collectRefs(allRefs, refs);
        this.transformer.collectRefs(allRefs, refs);
        if (this.by != null) {
            this.by.collectRefs(allRefs, refs);
        }
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        this.left.collectVars(allVars, vars);
        this.transformer.collectVars(allVars, vars);
        if (this.by != null) {
            this.by.collectVars(allVars, vars);
        }
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        this.left.collectFreeVariables(vars);
        this.transformer.collectFreeVariables(vars);
        if (this.by != null) {
            this.by.collectFreeVariables(vars);
        }
    }

    @Override
    public void validateType(Environment environment) throws Expression.TypeValidationException {
        this.left.validateType(environment);
        this.transformer.validateType(environment);
        this.by.validateType(environment);
    }

    @Override
    public CompiledQualifier compile(SimplificationContext context) {
        CompiledQualifier q = this.left.compile(context);
        try {
            Types.unify(this.cType, q.pattern.getType());
        }
        catch (UnificationException e) {
            context.getErrorLog().log(this.location, "Transformation function must be generic on list elements.");
        }
        q.value = this.by == null ? context.apply(this.transformer, q.value) : context.apply(this.transformer, context.lambda(q.pattern.copy(), this.by), q.value);
        return q;
    }

    @Override
    public void resolve(TranslationContext context) {
        this.transformer = this.transformer.resolve(context);
        this.left.resolve(context);
        if (this.by != null) {
            this.by = this.by.resolve(context);
        }
    }

    @Override
    public void decorate(ExpressionDecorator decorator) {
        this.transformer = this.transformer.decorate(decorator);
        if (this.by != null) {
            this.by = this.by.decorate(decorator);
        }
        this.left.decorate(decorator);
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
        this.left.collectEffects(effects);
        this.transformer.collectEffects(effects);
        if (this.by != null) {
            this.by.collectEffects(effects);
        }
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.left.setLocationDeep(loc);
            this.transformer.setLocationDeep(loc);
            if (this.by != null) {
                this.by.setLocationDeep(loc);
            }
        }
    }

    @Override
    public void accept(ListQualifierVisitor visitor) {
        visitor.visit(this);
    }
}

