/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions.block;

import org.simantics.scl.compiler.elaboration.expressions.Case;
import org.simantics.scl.compiler.elaboration.expressions.EMatch;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLet;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.block.Statement;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class LetStatement
extends Statement {
    public Expression pattern;
    public Expression value;

    public LetStatement(Expression pattern, Expression value) {
        this.pattern = pattern;
        this.value = value;
    }

    @Override
    public Expression toExpression(TranslationContext context, boolean monadic, Expression in) {
        if (this.pattern instanceof EVariable) {
            return new ESimpleLet(((EVariable)this.pattern).getVariable(), this.value, in);
        }
        return new EMatch(this.location, new Expression[]{this.value}, new Case(this.pattern, in));
    }

    @Override
    public void toString(StringBuilder b, TypeUnparsingContext tuc) {
        this.pattern.toString(b, tuc);
        b.append(" = ");
        this.value.toString(b, tuc);
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.pattern.setLocationDeep(loc);
            this.value.setLocationDeep(loc);
        }
    }
}

