/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions.block;

import org.simantics.scl.compiler.elaboration.expressions.EBind;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.block.Statement;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class BindStatement
extends Statement {
    public Expression pattern;
    public Expression value;

    public BindStatement(Expression pattern, Expression value) {
        this.pattern = pattern;
        this.value = value;
    }

    @Override
    public Expression toExpression(TranslationContext context, boolean monadic, Expression in) {
        if (!monadic) {
            context.getErrorLog().log(this.location, "Bind statements are allowed only in mdo-blocks.");
        }
        return new EBind(this.location, this.pattern, this.value, in);
    }

    @Override
    public void toString(StringBuilder b, TypeUnparsingContext tuc) {
        this.pattern.toString(b, tuc);
        b.append(" <- ");
        this.value.toString(b, tuc);
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.pattern.setLocationDeep(loc);
            this.value.setLocationDeep(loc);
        }
    }
}

