/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.util.Typed;

public class Variable
implements Typed {
    public static final Variable[] EMPTY_ARRAY = new Variable[0];
    String name;
    Type type;
    private IVal val;

    public Variable(String name) {
        this.name = name;
    }

    public Variable(String name, Type type) {
        this.name = name;
        this.type = type;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setType(Type type) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (this.type != null) {
            throw new IllegalStateException();
        }
        this.type = type;
    }

    public String toString() {
        return this.name;
    }

    public void setVal(IVal val) {
        this.val = val;
        val.setLabel(this.name);
    }

    public IVal getVal() {
        if (this.val == null) {
            throw new InternalCompilerError("Variable " + this.name + " (with type " + this.type + ") is not given value anywhere.");
        }
        return this.val;
    }

    public Variable copy() {
        return new Variable(this.name, this.type);
    }

    public void setName(String name) {
        this.name = name;
    }
}

