/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.references.Val;
import org.simantics.scl.compiler.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.contexts.PrintingContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.decomposed.DecomposedExpression;
import org.simantics.scl.compiler.elaboration.errors.NotPatternException;
import org.simantics.scl.compiler.elaboration.expressions.EApplyType;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.ELambdaType;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLambda;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.StandardExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.lhstype.LhsType;
import org.simantics.scl.compiler.elaboration.expressions.lhstype.PatternMatchingLhs;
import org.simantics.scl.compiler.elaboration.internal.ExpressionDecorator;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.query.QAtom;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.interpreted.IExpression;
import org.simantics.scl.compiler.parsing.Symbol;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.compiler.top.SCLValueCache;
import org.simantics.scl.types.TForAll;
import org.simantics.scl.types.TFun;
import org.simantics.scl.types.TPred;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.kinds.Kinds;
import org.simantics.scl.types.util.TypeUnparsingContext;
import org.simantics.scl.types.util.Typed;

public abstract class Expression
extends Symbol
implements Typed {
    public static final Expression[] EMPTY_ARRAY = new Expression[0];
    private transient Type type;
    protected static final int PRINTING_PRECEDENCE_APPLY = 0;
    protected static final int PRINTING_PRECEDENCE_MATCH = 2;
    protected static final int PRINTING_PRECEDENCE_MAX = 10;

    public Expression() {
    }

    public Expression(long loc) {
        this.location = loc;
    }

    @Override
    public Type getType() {
        if (this.type == null) {
            try {
                this.updateType();
            }
            catch (MatchException e) {
                throw new InternalCompilerError(e);
            }
            if (this.type == null) {
                throw new InternalCompilerError(String.valueOf(this.getClass().getSimpleName()) + ".updateType couldn't compute its type.");
            }
        }
        return this.type;
    }

    public void setType(Type type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.type = type;
    }

    public Expression inferType(TypingContext context) {
        System.out.println(String.valueOf(this.hashCode()) + " " + this.getClass().getSimpleName());
        return this.checkBasicType(context, Types.metaVar(Kinds.STAR));
    }

    public Expression checkBasicType(TypingContext context, Type requiredType) {
        return context.subsume(this.inferType(context), requiredType);
    }

    public final Expression checkType(TypingContext context, Type requiredType) {
        if (!context.isInPattern()) {
            if ((requiredType = Types.weakCanonical(requiredType)) instanceof TForAll) {
                TForAll forAll = (TForAll)requiredType;
                TVar var = forAll.var;
                TVar newVar = Types.var(var.getKind());
                requiredType = Types.canonical(forAll.type).replace(var, newVar);
                return new ELambdaType(new TVar[]{newVar}, this.checkType(context, requiredType));
            }
            if (requiredType instanceof TFun) {
                TFun fun = (TFun)requiredType;
                if (fun.domain instanceof TPred) {
                    ArrayList<Variable> constraints = new ArrayList<Variable>(2);
                    do {
                        constraints.add(new Variable("constraint", fun.domain));
                        requiredType = Types.canonical(fun.range);
                        if (!(requiredType instanceof TFun)) break;
                        fun = (TFun)requiredType;
                    } while (fun.domain instanceof TPred);
                    context.pushConstraintFrame(constraints.toArray(new Variable[constraints.size()]));
                    Expression expression = this.checkType(context, requiredType);
                    context.popConstraintFrame();
                    int i = constraints.size() - 1;
                    while (i >= 0) {
                        expression = new ESimpleLambda((Variable)constraints.get(i), expression);
                        --i;
                    }
                    return expression;
                }
                if (fun.domain == Types.PUNIT) {
                    context.pushEffectUpperBound(this.location, fun.effect);
                    Expression expr = this.checkType(context, fun.range);
                    context.popEffectUpperBound();
                    Variable var = new Variable("punit", Types.PUNIT);
                    return new ESimpleLambda(this.location, var, fun.effect, expr);
                }
            }
        }
        return this.checkBasicType(context, requiredType);
    }

    public abstract void collectRefs(TObjectIntHashMap<SCLValue> var1, TIntHashSet var2);

    public abstract void collectVars(TObjectIntHashMap<Variable> var1, TIntHashSet var2);

    public Expression decomposeMatching() {
        return this;
    }

    public String toString() {
        PrintingContext context = new PrintingContext();
        this.toString(context, 10);
        return context.toString();
    }

    public String toString(TypeUnparsingContext tuc) {
        StringBuilder b = new StringBuilder();
        this.toString(b, tuc);
        return b.toString();
    }

    public void toString(PrintingContext context, int precedence) {
        context.append("<");
        context.append(this.getClass().getSimpleName());
        context.append(">");
    }

    public abstract void toString(StringBuilder var1, TypeUnparsingContext var2);

    public abstract void validateType(Environment var1) throws TypeValidationException;

    protected abstract void updateType() throws MatchException;

    public static void assertEquals(long loc, Type a, Type b) throws TypeValidationException {
        if (!Types.equals(a, b)) {
            throw new TypeValidationException(loc);
        }
    }

    public abstract IVal toVal(Environment var1, CodeWriter var2);

    public Expression closure(TVar ... vars) {
        if (vars.length == 0) {
            return this;
        }
        return new ELambdaType(vars, this);
    }

    public abstract void collectFreeVariables(THashSet<Variable> var1);

    public abstract Expression simplify(SimplificationContext var1);

    public abstract Expression resolve(TranslationContext var1);

    public String getPatternHead() throws NotPatternException {
        throw new NotPatternException(this);
    }

    public LhsType getLhsType() throws NotPatternException {
        throw new NotPatternException(this);
    }

    protected void collectVariableNames(PatternMatchingLhs lhsType) throws NotPatternException {
        throw new NotPatternException(this);
    }

    public void getParameters(TranslationContext translationContext, ArrayList<Expression> parameters) {
        throw new InternalCompilerError("Class " + this.getClass().getSimpleName() + " does not support getParameters.");
    }

    public Expression resolveAsPattern(TranslationContext context) {
        context.getErrorLog().log(this.location, "Pattern was expected here.");
        return new EError();
    }

    public void removeFreeVariables(THashSet<Variable> vars) {
        throw new InternalCompilerError(String.valueOf(this.getClass().getSimpleName()) + " is not a pattern.");
    }

    public Expression checkTypeAsPattern(TypingContext context, Type requiredType) {
        if (context.isInPattern()) {
            throw new InternalCompilerError("Already in a pattern.");
        }
        context.setInPattern(true);
        Expression expression = this.checkType(context, requiredType);
        context.setInPattern(false);
        return expression;
    }

    public THashSet<Variable> getFreeVariables() {
        THashSet result = new THashSet();
        this.collectFreeVariables((THashSet<Variable>)result);
        return result;
    }

    public static Expression[] concat(Expression[] a, Expression[] b) {
        if (a.length == 0) {
            return b;
        }
        if (b.length == 0) {
            return a;
        }
        Expression[] result = new Expression[a.length + b.length];
        int i = 0;
        while (i < a.length) {
            result[i] = a[i];
            ++i;
        }
        i = 0;
        while (i < b.length) {
            result[i + a.length] = b[i];
            ++i;
        }
        return result;
    }

    public Expression replace(ReplaceContext context) {
        throw new InternalCompilerError(String.valueOf(this.getClass().getSimpleName()) + " does not support replace.");
    }

    public static Expression[] replace(ReplaceContext context, Expression[] expressions) {
        Expression[] result = new Expression[expressions.length];
        int i = 0;
        while (i < expressions.length) {
            result[i] = expressions[i].replace(context);
            ++i;
        }
        return result;
    }

    public Expression copy() {
        return this.replace(new ReplaceContext());
    }

    public abstract void setLocationDeep(long var1);

    public Expression replaceInPattern(ReplaceContext context) {
        context.inPattern = true;
        Expression result = this.replace(context);
        context.inPattern = false;
        return result;
    }

    public int getFunctionDefinitionArity() throws NotPatternException {
        throw new NotPatternException(this);
    }

    public IVal lambdaToVal(Environment env, CodeWriter w) {
        DecomposedExpression decomposed = DecomposedExpression.decompose(this);
        CodeWriter newW = w.createFunction(decomposed.typeParameters, decomposed.effect, decomposed.returnType, decomposed.parameterTypes);
        IVal[] parameters = newW.getParameters();
        Val functionVal = newW.getFunction().getTarget();
        int i = 0;
        while (i < parameters.length) {
            decomposed.parameters[i].setVal(parameters[i]);
            ++i;
        }
        newW.return_(decomposed.body.toVal(env, newW));
        return functionVal;
    }

    public IExpression toIExpression(SCLValueCache valueCache) {
        throw new UnsupportedOperationException();
    }

    public static IExpression[] toIExpressions(SCLValueCache valueCache, Expression[] expressions) {
        IExpression[] result = new IExpression[expressions.length];
        int i = 0;
        while (i < expressions.length) {
            result[i] = expressions[i].toIExpression(valueCache);
            ++i;
        }
        return result;
    }

    public Expression applyType(Type type) {
        return new EApplyType(this.location, this, type);
    }

    public abstract Expression decorate(ExpressionDecorator var1);

    public boolean isEffectful() {
        return true;
    }

    public boolean isFunctionPattern() {
        return false;
    }

    public boolean isConstructorApplication() {
        return false;
    }

    public abstract void collectEffects(THashSet<Type> var1);

    public Type getEffect() {
        THashSet effects = new THashSet();
        this.collectEffects((THashSet<Type>)effects);
        return Types.union((Type[])effects.toArray((Object[])new Type[effects.size()]));
    }

    public abstract void accept(ExpressionVisitor var1);

    public void collectRelationRefs(final TObjectIntHashMap<SCLRelation> allRefs, final TIntHashSet refs) {
        this.accept(new StandardExpressionVisitor(){

            @Override
            public void visit(QAtom query) {
                int id = allRefs.get((Object)query.relation);
                if (id >= 0) {
                    refs.add(id);
                }
            }
        });
    }

    public static class TypeValidationException
    extends Exception {
        private static final long serialVersionUID = 3181298127162041248L;
        long loc;

        public TypeValidationException(long loc) {
            this.loc = loc;
        }

        public long getLoc() {
            return this.loc;
        }

        public TypeValidationException(long loc, Throwable cause) {
            super(cause);
            this.loc = loc;
        }
    }
}

