/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.SimplifiableExpression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.internal.ExpressionDecorator;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.query.QExists;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryCompilationContext;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryCompilationMode;
import org.simantics.scl.compiler.elaboration.relations.compilation.UnsolvableQueryException;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.exceptions.UnificationException;
import org.simantics.scl.types.kinds.Kinds;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class EWhen
extends SimplifiableExpression {
    Query query;
    Expression action;
    Variable[] variables;

    public EWhen(Query query, Expression action) {
        this.query = query;
        this.action = action;
    }

    public EWhen(Query query, Expression action, Variable[] variables) {
        this.query = query;
        this.action = action;
        this.variables = variables;
    }

    @Override
    public void collectRefs(TObjectIntHashMap<SCLValue> allRefs, TIntHashSet refs) {
        this.query.collectRefs(allRefs, refs);
        this.action.collectRefs(allRefs, refs);
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        this.query.collectVars(allVars, vars);
        this.action.collectVars(allVars, vars);
    }

    @Override
    public void toString(StringBuilder b, TypeUnparsingContext tuc) {
        b.append("<when>");
    }

    @Override
    public void validateType(Environment environment) throws Expression.TypeValidationException {
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(Types.UNIT);
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        try {
            Types.unify(requiredType, Types.UNIT);
        }
        catch (UnificationException e) {
            context.typeError(this.location, requiredType, Types.UNIT);
            return this;
        }
        Variable[] variableArray = this.variables;
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray[n2];
            variable.setType(Types.metaVar(Kinds.STAR));
            ++n2;
        }
        this.query.checkType(context);
        this.action.checkType(context, Types.UNIT);
        context.declareEffect(this.location, this.query.getEffect(1));
        return this;
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        this.action.collectFreeVariables(vars);
        this.query.collectFreeVariables(vars);
        Variable[] variableArray = this.variables;
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable var = variableArray[n2];
            vars.remove((Object)var);
            ++n2;
        }
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        this.query = this.query.simplify(context);
        try {
            QueryCompilationContext queryCompilationContext = new QueryCompilationContext(context, QueryCompilationMode.ITERATE, null, this.action);
            new QExists(this.variables, this.query).generate(queryCompilationContext);
            return queryCompilationContext.getContinuation().simplify(context);
        }
        catch (UnsolvableQueryException e) {
            context.getErrorLog().log(this.getLocation(), "Failed to compile query.");
            return new EError(this.getLocation());
        }
    }

    @Override
    public Expression resolve(TranslationContext context) {
        context.pushExistentialFrame();
        this.query = this.query.resolve(context);
        this.action = this.action.resolve(context);
        this.variables = context.popExistentialFrame();
        return this;
    }

    @Override
    public Expression decorate(ExpressionDecorator decorator) {
        return decorator.decorate(this);
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
        this.query.collectEffects(1, effects);
        this.action.collectEffects(effects);
    }

    @Override
    public Expression replace(ReplaceContext context) {
        Variable[] newVariables = new Variable[this.variables.length];
        int i = 0;
        while (i < this.variables.length) {
            Variable newVariable;
            Variable variable = this.variables[i];
            newVariables[i] = newVariable = new Variable(variable.name, variable.getType());
            context.varMap.put((Object)variable, (Object)new EVariable(newVariable));
            ++i;
        }
        EWhen result = new EWhen(this.query.replace(context), this.action.replace(context), newVariables);
        int i2 = 0;
        while (i2 < this.variables.length) {
            context.varMap.remove((Object)this.variables[i2]);
            ++i2;
        }
        return result;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.query.setLocationDeep(loc);
            this.action.setLocationDeep(loc);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

