/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.elaboration.contexts.PrintingContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.internal.ExpressionDecorator;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.interpreted.IExpression;
import org.simantics.scl.compiler.interpreted.IVariable;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.compiler.top.SCLValueCache;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.kinds.Kinds;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class EVariable
extends Expression {
    Variable variable;

    public EVariable(Variable variable) {
        this.variable = variable;
    }

    public EVariable(long loc, Variable variable) {
        super(loc);
        this.variable = variable;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public void setVariable(Variable variable) {
        this.variable = variable;
    }

    @Override
    public void collectRefs(TObjectIntHashMap<SCLValue> allRefs, TIntHashSet refs) {
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        int id = allVars.get((Object)this.variable);
        if (id >= 0) {
            vars.add(id);
        }
    }

    @Override
    public void toString(StringBuilder b, TypeUnparsingContext tuc) {
        b.append(this.variable == null ? "???" : this.variable.toString());
    }

    @Override
    public void validateType(Environment environment) throws Expression.TypeValidationException {
        this.setType(this.variable.getType());
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(this.variable.getType());
    }

    @Override
    public IVal toVal(Environment env, CodeWriter w) {
        return this.variable.getVal();
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        vars.add((Object)this.variable);
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        Expression expression = context.getInlinedValue(this.variable);
        if (expression != null) {
            return expression.copy();
        }
        return this;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        return this;
    }

    @Override
    public void getParameters(TranslationContext translationContext, ArrayList<Expression> parameters) {
    }

    @Override
    public void removeFreeVariables(THashSet<Variable> vars) {
        vars.remove((Object)this.variable);
    }

    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        return this;
    }

    @Override
    public Expression replace(ReplaceContext context) {
        if (context.inPattern) {
            Type type = this.variable.getType().replace(context.tvarMap);
            Variable newVariable = new Variable(this.variable.name);
            newVariable.setType(type);
            EVariable result = new EVariable(newVariable);
            context.varMap.put((Object)this.variable, (Object)result);
            return result;
        }
        Expression expression = (Expression)context.varMap.get((Object)this.variable);
        if (expression != null) {
            return expression.copy();
        }
        return new EVariable(this.variable);
    }

    @Override
    public IExpression toIExpression(SCLValueCache valueCache) {
        return new IVariable(this.variable);
    }

    @Override
    public Expression inferType(TypingContext context) {
        if (context.isInPattern()) {
            this.variable.setType(Types.metaVar(Kinds.STAR));
        }
        return this;
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        if (context.isInPattern()) {
            this.variable.setType(requiredType);
            return this;
        }
        return context.subsume(this, requiredType);
    }

    @Override
    public Expression decorate(ExpressionDecorator decorator) {
        return decorator.decorate(this);
    }

    @Override
    public boolean isEffectful() {
        return false;
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
    }

    @Override
    public void toString(PrintingContext context, int precedence) {
        context.append(this.variable == null ? "nullVariable" + this.hashCode() : this.variable.toString());
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

