/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import java.util.ArrayList;
import org.simantics.scl.compiler.elaboration.contexts.PrintingContext;
import org.simantics.scl.compiler.elaboration.errors.NotPatternException;
import org.simantics.scl.compiler.elaboration.expressions.ASTExpression;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.lhstype.FunctionDefinitionLhs;
import org.simantics.scl.compiler.elaboration.expressions.lhstype.LhsType;
import org.simantics.scl.compiler.elaboration.expressions.lhstype.PatternMatchingLhs;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class EVar
extends ASTExpression {
    public final String name;

    public EVar(long location, String name) {
        this.location = location;
        this.name = name;
    }

    public EVar(String name) {
        this(9223372034707292160L, name);
    }

    @Override
    public void toString(StringBuilder b, TypeUnparsingContext tuc) {
        b.append(this.name);
    }

    @Override
    public String getPatternHead() {
        return this.name;
    }

    @Override
    public LhsType getLhsType() throws NotPatternException {
        if (TranslationContext.isConstructorName(this.name)) {
            return new PatternMatchingLhs();
        }
        return new FunctionDefinitionLhs(this.name);
    }

    @Override
    protected void collectVariableNames(PatternMatchingLhs lhsType) throws NotPatternException {
        if (!TranslationContext.isConstructorName(this.name)) {
            lhsType.variableNames.add(this.name);
        }
    }

    @Override
    public Expression resolve(TranslationContext context) {
        return context.resolveExpression(this.location, this.name);
    }

    @Override
    public void getParameters(TranslationContext translationContext, ArrayList<Expression> parameters) {
    }

    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        return context.resolvePattern(this);
    }

    @Override
    public int getFunctionDefinitionArity() throws NotPatternException {
        if (TranslationContext.isConstructorName(this.name)) {
            throw new NotPatternException(this);
        }
        return 0;
    }

    @Override
    public boolean isConstructorApplication() {
        return TranslationContext.isConstructorName(this.name);
    }

    @Override
    public void toString(PrintingContext context, int precedence) {
        context.append(this.name);
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
        }
    }
}

