/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.codegen.values.StringConstant;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.expressions.ASTExpression;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EListLiteral;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class EStringLiteral
extends ASTExpression {
    String[] strings;
    Expression[] expressions;

    public EStringLiteral(String[] strings, Expression[] expressions) {
        this.strings = strings;
        this.expressions = expressions;
    }

    @Override
    public void toString(StringBuilder b, TypeUnparsingContext tuc) {
        b.append("<stringLiteral>");
    }

    @Override
    public Expression resolve(TranslationContext context) {
        Expression[] components = new Expression[this.strings.length + this.expressions.length];
        SCLValue showForPrinting = context.getEnvironment().getValue(Name.create("Prelude", "showForPrinting"));
        int i = 0;
        while (i < this.strings.length) {
            components[i * 2] = new ELiteral(new StringConstant(this.strings[i]));
            ++i;
        }
        i = 0;
        while (i < this.expressions.length) {
            components[i * 2 + 1] = new EApply((Expression)new EConstant(showForPrinting), this.expressions[i]);
            ++i;
        }
        return new EApply((Expression)new EConstant(context.getEnvironment().getValue(Name.create("Prelude", "sum"))), (Expression)new EListLiteral(components)).resolve(context);
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            Expression[] expressionArray = this.expressions;
            int n = this.expressions.length;
            int n2 = 0;
            while (n2 < n) {
                Expression expression = expressionArray[n2];
                expression.setLocationDeep(loc);
                ++n2;
            }
        }
    }
}

