/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.elaboration.contexts.PrintingContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.internal.ExpressionDecorator;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.interpreted.IExpression;
import org.simantics.scl.compiler.interpreted.ILet;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.compiler.top.SCLValueCache;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.kinds.Kinds;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class ESimpleLet
extends Expression {
    Variable variable;
    Expression value;
    Expression in;

    public ESimpleLet(Variable variable, Expression value, Expression in) {
        if (variable == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        if (in == null) {
            throw new NullPointerException();
        }
        this.variable = variable;
        this.value = value;
        this.in = in;
    }

    public ESimpleLet(long loc, Variable variable, Expression value, Expression in) {
        super(loc);
        if (variable == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        if (in == null) {
            throw new NullPointerException();
        }
        this.variable = variable;
        this.value = value;
        this.in = in;
    }

    @Override
    public void collectRefs(TObjectIntHashMap<SCLValue> allRefs, TIntHashSet refs) {
        this.value.collectRefs(allRefs, refs);
        this.in.collectRefs(allRefs, refs);
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        this.value.collectVars(allVars, vars);
        this.in.collectVars(allVars, vars);
    }

    @Override
    public void toString(StringBuilder b, TypeUnparsingContext tuc) {
        b.append("(let ");
        b.append(this.variable.toString());
        b.append(" = ");
        this.value.toString(b, tuc);
        b.append(" in ");
        this.in.toString(b, tuc);
        b.append(")");
    }

    @Override
    public void validateType(Environment environment) throws Expression.TypeValidationException {
        this.value.validateType(environment);
        ESimpleLet.assertEquals(this.location, this.variable.type, this.value.getType());
        this.in.validateType(environment);
        this.setType(this.in.getType());
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(this.in.getType());
    }

    @Override
    public IVal toVal(Environment env, CodeWriter w) {
        this.variable.setVal(this.value.toVal(env, w));
        return this.in.toVal(env, w);
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        this.value.collectFreeVariables(vars);
        this.in.collectFreeVariables(vars);
        vars.remove((Object)this.variable);
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        this.value = this.value.simplify(context);
        if (this.value instanceof EConstant || this.value instanceof ELiteral) {
            context.addInlinedVariable(this.variable, this.value);
            return this.in.simplify(context);
        }
        this.in = this.in.simplify(context);
        return this;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        this.value = this.value.resolve(context);
        this.in = this.in.resolve(context);
        return this;
    }

    @Override
    public Expression replace(ReplaceContext context) {
        Variable newVariable = this.variable.copy();
        context.varMap.put((Object)this.variable, (Object)new EVariable(newVariable));
        ESimpleLet result = new ESimpleLet(newVariable, this.value.replace(context), this.in.replace(context));
        context.varMap.remove((Object)this.variable);
        return result;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.value.setLocationDeep(loc);
            this.in.setLocationDeep(loc);
        }
    }

    @Override
    public IExpression toIExpression(SCLValueCache valueCache) {
        return new ILet(this.variable, this.value.toIExpression(valueCache), this.in.toIExpression(valueCache));
    }

    private void checkBinding(TypingContext context) {
        if (this.variable.getType() == null) {
            this.variable.setType(Types.metaVar(Kinds.STAR));
        }
        this.value = this.value.checkType(context, this.variable.type);
    }

    @Override
    public Expression inferType(TypingContext context) {
        this.checkBinding(context);
        this.in = this.in.inferType(context);
        return this;
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        this.checkBinding(context);
        this.in = this.in.checkType(context, requiredType);
        return this;
    }

    @Override
    public Expression decorate(ExpressionDecorator decorator) {
        this.value = this.value.decorate(decorator);
        this.in = this.in.decorate(decorator);
        return decorator.decorate(this);
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
        this.value.collectEffects(effects);
        this.in.collectEffects(effects);
    }

    @Override
    public void toString(PrintingContext context, int precedence) {
        if (precedence <= 0) {
            context.append('(');
        }
        context.indent();
        context.newLine();
        context.append("let ");
        context.append(this.variable);
        context.append(" = ");
        this.value.toString(context, 10);
        context.newLine();
        context.append("in ");
        context.dedent();
        this.in.toString(context, precedence);
        if (precedence <= 0) {
            context.append(')');
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

