/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.contexts.PrintingContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.internal.ExpressionDecorator;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.interpreted.IExpression;
import org.simantics.scl.compiler.interpreted.ILambda;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.compiler.top.SCLValueCache;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.exceptions.UnificationException;
import org.simantics.scl.types.kinds.Kinds;
import org.simantics.scl.types.util.MultiFunction;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class ESimpleLambda
extends Expression {
    public Variable parameter;
    public Expression value;
    public Type effect = Types.NO_EFFECTS;

    public ESimpleLambda(Variable parameter, Expression value) {
        this.parameter = parameter;
        this.value = value;
    }

    public ESimpleLambda(Type effect, Variable parameter, Expression value) {
        this.parameter = parameter;
        this.value = value;
        this.effect = effect;
    }

    public ESimpleLambda(long loc, Variable parameter, Expression value) {
        super(loc);
        this.parameter = parameter;
        this.value = value;
    }

    public ESimpleLambda(long loc, Variable parameter, Type effect, Expression value) {
        super(loc);
        this.parameter = parameter;
        this.value = value;
        this.effect = effect;
    }

    @Override
    public void collectRefs(TObjectIntHashMap<SCLValue> allRefs, TIntHashSet refs) {
        this.value.collectRefs(allRefs, refs);
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        this.value.collectVars(allVars, vars);
    }

    @Override
    public Expression decomposeMatching() {
        this.value = this.value.decomposeMatching();
        return this;
    }

    @Override
    public void toString(StringBuilder b, TypeUnparsingContext tuc) {
        b.append("(\\");
        b.append(this.parameter.toString());
        b.append(" -> ");
        this.value.toString(b, tuc);
        b.append(")");
    }

    @Override
    public void toString(PrintingContext context, int precedence) {
        context.append("(\\");
        context.append(this.parameter);
        context.append(" -> ");
        this.value.toString(context, 10);
        context.append(")");
    }

    @Override
    public void validateType(Environment environment) throws Expression.TypeValidationException {
        this.value.validateType(environment);
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(Types.functionE(Types.canonical(this.parameter.type), this.effect, this.value.getType()));
    }

    @Override
    public IVal toVal(Environment env, CodeWriter w) {
        return this.lambdaToVal(env, w);
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        this.value.collectFreeVariables(vars);
        vars.remove((Object)this.parameter);
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        this.value = this.value.simplify(context);
        return this;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        this.value = this.value.resolve(context);
        return this;
    }

    @Override
    public Expression replace(ReplaceContext context) {
        Variable newParameter = this.parameter.copy();
        context.varMap.put((Object)this.parameter, (Object)new EVariable(newParameter));
        ESimpleLambda result = new ESimpleLambda(this.getLocation(), newParameter, this.effect.replace(context.tvarMap), this.value.replace(context));
        context.varMap.remove((Object)this.parameter);
        return result;
    }

    public Type getLocalEffect() {
        return this.effect;
    }

    public void setEffect(Type effect) {
        if (effect == null) {
            throw new InternalCompilerError();
        }
        this.effect = effect;
    }

    @Override
    public IExpression toIExpression(SCLValueCache valueCache) {
        return new ILambda(this.parameter, this.value.toIExpression(valueCache));
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        MultiFunction mfun;
        try {
            mfun = Types.unifyFunction(requiredType, 1);
        }
        catch (UnificationException e) {
            context.getErrorLog().log(this.location, "Required type is <" + requiredType + "> which is incompatible with lambda.");
            this.setType(Types.metaVar(Kinds.STAR));
            return this;
        }
        this.effect = mfun.effect;
        context.pushEffectUpperBound(this.location, mfun.effect);
        this.parameter.setType(mfun.parameterTypes[0]);
        this.value = this.value.checkType(context, mfun.returnType);
        context.popEffectUpperBound();
        return this;
    }

    @Override
    public Expression inferType(TypingContext context) {
        this.effect = Types.metaVar(Kinds.EFFECT);
        context.pushEffectUpperBound(this.location, this.effect);
        this.parameter.setType(Types.metaVar(Kinds.STAR));
        this.value = this.value.checkType(context, Types.metaVar(Kinds.STAR));
        context.popEffectUpperBound();
        return this;
    }

    @Override
    public Expression decorate(ExpressionDecorator decorator) {
        if (decorator.decorateSubstructure(this)) {
            this.value = this.value.decorate(decorator);
        }
        return decorator.decorate(this);
    }

    @Override
    public boolean isEffectful() {
        return false;
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.value.setLocationDeep(loc);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

