/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.contexts.EnvironmentalContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.EWhen;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Expressions;
import org.simantics.scl.compiler.elaboration.expressions.SimplifiableExpression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.internal.ExpressionDecorator;
import org.simantics.scl.compiler.elaboration.internal.StronglyConnectedComponents;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.query.compilation.DerivateException;
import org.simantics.scl.compiler.elaboration.relations.LocalRelation;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.kinds.Kinds;
import org.simantics.scl.types.util.TypeUnparsingContext;
import org.simantics.scl.types.util.Typed;

public class ERuleset
extends SimplifiableExpression {
    LocalRelation[] relations;
    Rule[] rules;
    Expression in;
    boolean stratified;
    private static final TCon MSet = Types.con("MSet", "T");
    private static final Name MSet_add = Name.create("MSet", "add");
    private static final Name MSet_create = Name.create("MSet", "create");
    private static final TCon MList = Types.con("MList", "T");
    private static final Name MList_add = Name.create("MList", "add");
    private static final Name MList_create = Name.create("MList", "create");
    private static final Name MList_removeLast = Name.create("MList", "removeLast");

    public ERuleset(LocalRelation[] relations, Rule[] rules, Expression in) {
        this.relations = relations;
        this.rules = rules;
        this.in = in;
    }

    private ERuleset(LocalRelation[] relations, Rule[] rules, Expression in, boolean stratified) {
        this.relations = relations;
        this.rules = rules;
        this.in = in;
        this.stratified = stratified;
    }

    private void checkRuleTypes(TypingContext context) {
        Object[] objectArray = this.relations;
        int n = this.relations.length;
        int n2 = 0;
        while (n2 < n) {
            LocalRelation relation = objectArray[n2];
            Expression[] expressionArray = relation.constraints;
            int n3 = relation.constraints.length;
            int n4 = 0;
            while (n4 < n3) {
                Expression constraint = expressionArray[n4];
                context.addConstraintDemand((EVariable)constraint);
                ++n4;
            }
            ++n2;
        }
        objectArray = this.rules;
        n = this.rules.length;
        n2 = 0;
        while (n2 < n) {
            Object rule = objectArray[n2];
            Type[] parameterTypes = ((Rule)rule).headRelation.getParameterTypes();
            Expression[] parameters = ((Rule)rule).headParameters;
            Variable[] variableArray = ((Rule)rule).variables;
            int n5 = ((Rule)rule).variables.length;
            int n6 = 0;
            while (n6 < n5) {
                Variable variable = variableArray[n6];
                variable.setType(Types.metaVar(Kinds.STAR));
                ++n6;
            }
            int i = 0;
            while (i < parameters.length) {
                parameters[i] = parameters[i].checkType(context, parameterTypes[i]);
                ++i;
            }
            ((Rule)rule).body.checkType(context);
            ++n2;
        }
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        this.checkRuleTypes(context);
        this.in = this.in.checkBasicType(context, requiredType);
        return this;
    }

    @Override
    public Expression inferType(TypingContext context) {
        this.checkRuleTypes(context);
        this.in = this.in.inferType(context);
        return this;
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        Rule[] ruleArray = this.rules;
        int n = this.rules.length;
        int n2 = 0;
        while (n2 < n) {
            Rule rule = ruleArray[n2];
            Typed[] typedArray = rule.headParameters;
            int n3 = rule.headParameters.length;
            int n4 = 0;
            while (n4 < n3) {
                Expression parameter = typedArray[n4];
                parameter.collectFreeVariables(vars);
                ++n4;
            }
            rule.body.collectFreeVariables(vars);
            typedArray = rule.variables;
            n3 = rule.variables.length;
            n4 = 0;
            while (n4 < n3) {
                Typed var = typedArray[n4];
                vars.remove((Object)var);
                ++n4;
            }
            ++n2;
        }
        this.in.collectFreeVariables(vars);
    }

    @Override
    public void collectRefs(TObjectIntHashMap<SCLValue> allRefs, TIntHashSet refs) {
        Rule[] ruleArray = this.rules;
        int n = this.rules.length;
        int n2 = 0;
        while (n2 < n) {
            Rule rule = ruleArray[n2];
            Expression[] expressionArray = rule.headParameters;
            int n3 = rule.headParameters.length;
            int n4 = 0;
            while (n4 < n3) {
                Expression parameter = expressionArray[n4];
                parameter.collectRefs(allRefs, refs);
                ++n4;
            }
            rule.body.collectRefs(allRefs, refs);
            ++n2;
        }
        this.in.collectRefs(allRefs, refs);
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        Rule[] ruleArray = this.rules;
        int n = this.rules.length;
        int n2 = 0;
        while (n2 < n) {
            Rule rule = ruleArray[n2];
            Expression[] expressionArray = rule.headParameters;
            int n3 = rule.headParameters.length;
            int n4 = 0;
            while (n4 < n3) {
                Expression parameter = expressionArray[n4];
                parameter.collectVars(allVars, vars);
                ++n4;
            }
            rule.body.collectVars(allVars, vars);
            ++n2;
        }
        this.in.collectVars(allVars, vars);
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
        Rule[] ruleArray = this.rules;
        int n = this.rules.length;
        int n2 = 0;
        while (n2 < n) {
            Rule rule = ruleArray[n2];
            Expression[] expressionArray = rule.headParameters;
            int n3 = rule.headParameters.length;
            int n4 = 0;
            while (n4 < n3) {
                Expression parameter = expressionArray[n4];
                parameter.collectEffects(effects);
                ++n4;
            }
            rule.body.collectEffects(1, effects);
            ++n2;
        }
        this.in.collectEffects(effects);
    }

    @Override
    public Expression decorate(ExpressionDecorator decorator) {
        return decorator.decorate(this);
    }

    @Override
    public Expression resolve(TranslationContext context) {
        throw new InternalCompilerError();
    }

    private Expression stratify() {
        TObjectIntHashMap relationsToIds = new TObjectIntHashMap(this.relations.length, 0.5f, -1);
        int i = 0;
        while (i < this.relations.length) {
            relationsToIds.put((Object)this.relations[i], i);
            ++i;
        }
        TIntHashSet[] refsSets = new TIntHashSet[this.relations.length];
        int setCapacity = Math.min(10, this.relations.length);
        int i2 = 0;
        while (i2 < this.relations.length) {
            refsSets[i2] = new TIntHashSet(setCapacity);
            ++i2;
        }
        Rule[] ruleArray = this.rules;
        int n = this.rules.length;
        int n2 = 0;
        while (n2 < n) {
            Rule rule = ruleArray[n2];
            int headRelationId = relationsToIds.get((Object)rule.headRelation);
            TIntHashSet refsSet = refsSets[headRelationId];
            rule.body.collectRelationRefs((TObjectIntHashMap<SCLRelation>)relationsToIds, refsSet);
            Expression[] expressionArray = rule.headParameters;
            int n3 = rule.headParameters.length;
            int n4 = 0;
            while (n4 < n3) {
                Expression parameter = expressionArray[n4];
                parameter.collectRelationRefs((TObjectIntHashMap<SCLRelation>)relationsToIds, refsSet);
                ++n4;
            }
            ++n2;
        }
        final int[][] refs = new int[this.relations.length][];
        int i3 = 0;
        while (i3 < this.relations.length) {
            refs[i3] = refsSets[i3].toArray();
            ++i3;
        }
        final ArrayList components = new ArrayList();
        new StronglyConnectedComponents(this.relations.length){

            @Override
            protected void reportComponent(int[] component) {
                components.add(component);
            }

            @Override
            protected int[] findDependencies(int u) {
                return refs[u];
            }
        }.findComponents();
        if (components.size() == 1) {
            this.stratified = true;
            return this;
        }
        int[] strataPerRelation = new int[this.relations.length];
        int i4 = 0;
        while (i4 < components.size()) {
            int[] nArray = (int[])components.get(i4);
            int parameter = nArray.length;
            int refsSet = 0;
            while (refsSet < parameter) {
                int k = nArray[refsSet];
                strataPerRelation[k] = i4;
                ++refsSet;
            }
            ++i4;
        }
        ArrayList[] rulesPerStrata = new ArrayList[components.size()];
        int i5 = 0;
        while (i5 < components.size()) {
            rulesPerStrata[i5] = new ArrayList();
            ++i5;
        }
        Rule[] ruleArray2 = this.rules;
        int parameter = this.rules.length;
        int refsSet = 0;
        while (refsSet < parameter) {
            Rule rule = ruleArray2[refsSet];
            int stratum = strataPerRelation[relationsToIds.get((Object)rule.headRelation)];
            rulesPerStrata[stratum].add(rule);
            ++refsSet;
        }
        Expression cur = this.in;
        int stratum = components.size() - 1;
        while (stratum >= 0) {
            int[] cs = (int[])components.get(stratum);
            LocalRelation[] curRelations = new LocalRelation[cs.length];
            int i6 = 0;
            while (i6 < cs.length) {
                curRelations[i6] = this.relations[cs[i6]];
                ++i6;
            }
            ArrayList curRules = rulesPerStrata[stratum];
            cur = new ERuleset(curRelations, curRules.toArray(new Rule[curRules.size()]), cur, true);
            --stratum;
        }
        return cur;
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        if (this.stratified) {
            return this.simplifyStratified(context);
        }
        return this.stratify().simplify(context);
    }

    private Expression simplifyStratified(SimplificationContext context) {
        int j;
        LocalRelation[] localRelationArray = this.relations;
        int n = this.relations.length;
        int n2 = 0;
        while (n2 < n) {
            LocalRelation relation = localRelationArray[n2];
            int i = 0;
            while (i < relation.constraints.length) {
                relation.constraints[i] = relation.constraints[i].simplify(context);
                ++i;
            }
            relation.table = Expressions.newVar("table" + relation.getName(), Types.apply((Type)MSet, Types.tuple(relation.getParameterTypes())));
            ++n2;
        }
        Expression continuation = this.in;
        Variable[] stacks = new Variable[this.relations.length];
        int i = 0;
        while (i < this.relations.length) {
            LocalRelation relation = this.relations[i];
            Type[] parameterTypes = relation.getParameterTypes();
            stacks[i] = Expressions.newVar("stack" + relation.getName(), Types.apply((Type)MList, Types.tuple(parameterTypes)));
            ++i;
        }
        THashMap diffables = new THashMap(this.relations.length);
        int i2 = 0;
        while (i2 < this.relations.length) {
            LocalRelation relation = this.relations[i2];
            Type[] parameterTypes = relation.getParameterTypes();
            Variable[] parameters = new Variable[parameterTypes.length];
            j = 0;
            while (j < parameterTypes.length) {
                parameters[j] = new Variable("p" + j, parameterTypes[j]);
                ++j;
            }
            diffables.put((Object)this.relations[i2], (Object)new Query.Diffable(i2, relation, parameters));
            ++i2;
        }
        ArrayList[] updateExpressions = new ArrayList[this.relations.length];
        int i3 = 0;
        while (i3 < this.relations.length) {
            updateExpressions[i3] = new ArrayList(2);
            ++i3;
        }
        ArrayList<Expression> seedExpressions = new ArrayList<Expression>();
        Rule[] ruleArray = this.rules;
        j = this.rules.length;
        int parameters = 0;
        while (parameters < j) {
            Query.Diff[] diffs;
            Rule rule = ruleArray[parameters];
            int i4 = 0;
            while (i4 < rule.headParameters.length) {
                rule.headParameters[i4] = rule.headParameters[i4].simplify(context);
                ++i4;
            }
            rule.body = rule.body.simplify(context);
            int id = ((Query.Diffable)diffables.get((Object)rule.headRelation)).id;
            Expression appendExp = Expressions.apply((EnvironmentalContext)context, (Type)Types.PROC, MList_add, Types.tuple(rule.headRelation.getParameterTypes()), Expressions.var(stacks[id]), Expressions.tuple(rule.headParameters));
            try {
                diffs = rule.body.derivate((THashMap<SCLRelation, Query.Diffable>)diffables);
            }
            catch (DerivateException e) {
                context.getErrorLog().log(e.location, "Recursion must not contain negations or aggragates.");
                return new EError();
            }
            Query.Diff[] diffArray = diffs;
            int n3 = diffs.length;
            int n4 = 0;
            while (n4 < n3) {
                Query.Diff diff = diffArray[n4];
                updateExpressions[diff.id].add(new EWhen(diff.query, appendExp, rule.variables).copy().simplify(context));
                ++n4;
            }
            if (diffs.length == 0) {
                seedExpressions.add(new EWhen(rule.body, appendExp, rule.variables).simplify(context));
            } else {
                Query query = rule.body.removeRelations(diffables.keySet());
                if (query != Query.EMPTY_QUERY) {
                    seedExpressions.add(new EWhen(query, appendExp, rule.variables).simplify(context));
                }
            }
            ++parameters;
        }
        Variable[] loops = new Variable[this.relations.length];
        int i5 = 0;
        while (i5 < loops.length) {
            loops[i5] = Expressions.newVar("loop" + this.relations[i5].getName(), Types.functionE(Types.INTEGER, (Type)Types.PROC, (Type)Types.UNIT));
            ++i5;
        }
        continuation = Expressions.seq(Expressions.apply(Types.PROC, Expressions.var(loops[0]), Expressions.integer(this.relations.length - 1)), continuation);
        Expression[] loopDefs = new Expression[this.relations.length];
        int i6 = 0;
        while (i6 < this.relations.length) {
            LocalRelation relation = this.relations[i6];
            Type[] parameterTypes = relation.getParameterTypes();
            Variable[] parameters2 = ((Query.Diffable)diffables.get((Object)relation)).parameters;
            Variable counter = Expressions.newVar("counter", Types.INTEGER);
            Type rowType = Types.tuple(parameterTypes);
            Variable row = Expressions.newVar("row", rowType);
            Expression handleRow = Expressions.tuple();
            for (Expression updateExpression : updateExpressions[i6]) {
                handleRow = Expressions.seq(updateExpression, handleRow);
            }
            handleRow = Expressions.if_(Expressions.apply((EnvironmentalContext)context, (Type)Types.PROC, MSet_add, rowType, Expressions.var(relation.table), Expressions.var(row)), handleRow, Expressions.tuple());
            handleRow = Expressions.seq(handleRow, Expressions.apply(Types.PROC, Expressions.var(loops[i6]), Expressions.integer(this.relations.length - 1)));
            Expression failure = Expressions.if_(Expressions.isZeroInteger(Expressions.var(counter)), Expressions.tuple(), Expressions.apply(Types.PROC, Expressions.var(loops[(i6 + 1) % this.relations.length]), Expressions.addInteger(Expressions.var(counter), Expressions.integer(-1))));
            Expression body = Expressions.matchWithDefault(Expressions.apply((EnvironmentalContext)context, (Type)Types.PROC, MList_removeLast, rowType, Expressions.var(stacks[i6])), Expressions.Just(Expressions.as(row, Expressions.tuple(Expressions.vars(parameters2)))), handleRow, failure);
            loopDefs[i6] = Expressions.lambda((Type)Types.PROC, counter, body);
            ++i6;
        }
        continuation = Expressions.letRec(loops, loopDefs, continuation);
        for (Expression seedExpression : seedExpressions) {
            continuation = Expressions.seq(seedExpression, continuation);
        }
        i = 0;
        while (i < stacks.length) {
            continuation = Expressions.let(stacks[i], Expressions.apply((EnvironmentalContext)context, (Type)Types.PROC, MList_create, Types.tuple(this.relations[i].getParameterTypes()), Expressions.tuple()), continuation);
            ++i;
        }
        LocalRelation[] localRelationArray2 = this.relations;
        int n5 = this.relations.length;
        int n6 = 0;
        while (n6 < n5) {
            LocalRelation relation = localRelationArray2[n6];
            continuation = Expressions.let(relation.table, Expressions.apply((EnvironmentalContext)context, (Type)Types.PROC, MSet_create, Types.tuple(relation.getParameterTypes()), Expressions.tuple()), continuation);
            ++n6;
        }
        return continuation.simplify(context);
    }

    @Override
    public void toString(StringBuilder b, TypeUnparsingContext tuc) {
        b.append("<ruleset>");
    }

    @Override
    public void validateType(Environment environment) throws Expression.TypeValidationException {
        this.in.validateType(environment);
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(this.in.getType());
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            Rule[] ruleArray = this.rules;
            int n = this.rules.length;
            int n2 = 0;
            while (n2 < n) {
                Rule rule = ruleArray[n2];
                rule.setLocationDeep(loc);
                ++n2;
            }
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    static class LocalRelationAux {
        Variable handleFunc;

        LocalRelationAux() {
        }
    }

    public static class Rule {
        public LocalRelation headRelation;
        public Expression[] headParameters;
        public Query body;
        public Variable[] variables;

        public Rule(LocalRelation headRelation, Expression[] headParameters, Query body) {
            this.headRelation = headRelation;
            this.headParameters = headParameters;
            this.body = body;
        }

        public void setLocationDeep(long loc) {
            Expression[] expressionArray = this.headParameters;
            int n = this.headParameters.length;
            int n2 = 0;
            while (n2 < n) {
                Expression parameter = expressionArray[n2];
                parameter.setLocationDeep(loc);
                ++n2;
            }
            this.body.setLocationDeep(loc);
        }
    }
}

