/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.THashMap;
import org.simantics.scl.compiler.elaboration.expressions.ASTExpression;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.ERuleset;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.block.RuleStatement;
import org.simantics.scl.compiler.elaboration.relations.LocalRelation;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class EPreRuleset
extends ASTExpression {
    RuleStatement[] statements;
    Expression in;

    public EPreRuleset(RuleStatement[] statements, Expression in) {
        this.statements = statements;
        this.in = in;
    }

    @Override
    public void toString(StringBuilder b, TypeUnparsingContext tuc) {
    }

    @Override
    public Expression resolve(TranslationContext context) {
        THashMap relations = new THashMap();
        ERuleset.Rule[] rules = new ERuleset.Rule[this.statements.length];
        context.pushRelationFrame();
        try {
            int i = 0;
            while (i < this.statements.length) {
                RuleStatement statement = this.statements[i];
                Expression head = statement.head;
                if (!(head instanceof EApply)) {
                    context.getErrorLog().log(head.location, "Invalid rule head.");
                    EError eError = new EError();
                    return eError;
                }
                EApply apply = (EApply)head;
                if (!(apply.function instanceof EVar)) {
                    context.getErrorLog().log(head.location, "Invalid relation in rule head.");
                    EError eError = new EError();
                    return eError;
                }
                String relationName = ((EVar)apply.function).name;
                LocalRelation relation = (LocalRelation)relations.get((Object)relationName);
                if (relation == null) {
                    relation = new LocalRelation(relationName, apply.parameters.length);
                    relations.put((Object)relationName, (Object)relation);
                    context.newRelation(relationName, relation);
                } else if (apply.parameters.length != relation.getArity()) {
                    context.getErrorLog().log(apply.location, "Different rules have different relation arity.");
                    EError eError = new EError();
                    return eError;
                }
                rules[i] = new ERuleset.Rule(relation, apply.parameters, statement.body);
                ++i;
            }
            ERuleset.Rule[] ruleArray = rules;
            int n = rules.length;
            int n2 = 0;
            while (n2 < n) {
                ERuleset.Rule rule = ruleArray[n2];
                context.pushExistentialFrame();
                int i2 = 0;
                while (i2 < rule.headParameters.length) {
                    rule.headParameters[i2] = rule.headParameters[i2].resolve(context);
                    ++i2;
                }
                rule.body = rule.body.resolve(context);
                rule.variables = context.popExistentialFrame();
                ++n2;
            }
            ERuleset eRuleset = new ERuleset(relations.values().toArray(new LocalRelation[relations.size()]), rules, this.in.resolve(context));
            return eRuleset;
        }
        finally {
            context.popRelationFrame();
        }
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            RuleStatement[] ruleStatementArray = this.statements;
            int n = this.statements.length;
            int n2 = 0;
            while (n2 < n) {
                RuleStatement statement = ruleStatementArray[n2];
                statement.setLocationDeep(loc);
                ++n2;
            }
            this.in.setLocationDeep(loc);
        }
    }
}

