/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.codegen.references.IVal;
import org.simantics.scl.compiler.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.elaboration.contexts.PrintingContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Case;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.internal.ExpressionDecorator;
import org.simantics.scl.compiler.elaboration.matching.PatternMatchingCompiler;
import org.simantics.scl.compiler.elaboration.matching.Row;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.parsing.Symbol;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.kinds.Kinds;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class EMatch
extends Expression {
    Expression[] scrutinee;
    Case[] cases;

    public EMatch(Expression[] scrutinee, Case ... cases) {
        this.scrutinee = scrutinee;
        this.cases = cases;
    }

    public EMatch(Expression scrutinee, Case ... cases) {
        this(new Expression[]{scrutinee}, cases);
    }

    public EMatch(long loc, Expression[] scrutinee, Case ... cases) {
        super(loc);
        this.scrutinee = scrutinee;
        this.cases = cases;
    }

    @Override
    public void collectRefs(TObjectIntHashMap<SCLValue> allRefs, TIntHashSet refs) {
        Symbol[] symbolArray = this.scrutinee;
        int n = this.scrutinee.length;
        int n2 = 0;
        while (n2 < n) {
            Expression s = symbolArray[n2];
            s.collectRefs(allRefs, refs);
            ++n2;
        }
        symbolArray = this.cases;
        n = this.cases.length;
        n2 = 0;
        while (n2 < n) {
            Symbol case_ = symbolArray[n2];
            ((Case)case_).collectRefs(allRefs, refs);
            ++n2;
        }
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        Symbol[] symbolArray = this.scrutinee;
        int n = this.scrutinee.length;
        int n2 = 0;
        while (n2 < n) {
            Expression s = symbolArray[n2];
            s.collectVars(allVars, vars);
            ++n2;
        }
        symbolArray = this.cases;
        n = this.cases.length;
        n2 = 0;
        while (n2 < n) {
            Symbol case_ = symbolArray[n2];
            ((Case)case_).collectVars(allVars, vars);
            ++n2;
        }
    }

    @Override
    public void toString(StringBuilder b, TypeUnparsingContext tuc) {
        b.append("(match");
        Expression[] expressionArray = this.scrutinee;
        int n = this.scrutinee.length;
        int n2 = 0;
        while (n2 < n) {
            Expression s = expressionArray[n2];
            b.append(" ");
            s.toString(b, tuc);
            ++n2;
        }
        b.append(" with ");
        int i = 0;
        while (i < this.cases.length) {
            if (i > 0) {
                b.append(" ; ");
            }
            this.cases[i].toString(1, b, tuc);
            ++i;
        }
        b.append(")");
    }

    @Override
    public void toString(PrintingContext context, int precedence) {
        if (precedence < 2) {
            context.append("(");
        }
        context.append("match ");
        int i = 0;
        while (i < this.scrutinee.length) {
            if (i > 0) {
                context.append(", ");
            }
            this.scrutinee[i].toString(context, 0);
            ++i;
        }
        context.append(" with");
        context.indent();
        i = 0;
        while (i < this.cases.length) {
            context.newLine();
            Case case_ = this.cases[i];
            int j = 0;
            while (j < case_.patterns.length) {
                if (j > 0) {
                    context.append(", ");
                }
                case_.patterns[j].toString(context, 0);
                ++j;
            }
            context.append(" -> ");
            case_.value.toString(context, 10);
            ++i;
        }
        if (precedence < 2) {
            context.append(')');
        }
        context.dedent();
    }

    @Override
    public void validateType(Environment environment) throws Expression.TypeValidationException {
    }

    @Override
    protected void updateType() {
        this.setType(this.cases[0].value.getType());
    }

    @Override
    public IVal toVal(Environment env, CodeWriter w) {
        ArrayList<Row> rows = new ArrayList<Row>(this.cases.length);
        Case[] caseArray = this.cases;
        int n = this.cases.length;
        int n2 = 0;
        while (n2 < n) {
            Case case_ = caseArray[n2];
            rows.add(new Row(case_.patterns, case_.value));
            ++n2;
        }
        IVal[] scrutineeVals = new IVal[this.scrutinee.length];
        int i = 0;
        while (i < this.scrutinee.length) {
            scrutineeVals[i] = this.scrutinee[i].toVal(env, w);
            ++i;
        }
        CodeWriter joinPoint = w.createBlock(this.getType());
        CodeWriter failurePoint = w.createBlock(new Type[0]);
        PatternMatchingCompiler.split(w, env, scrutineeVals, joinPoint.getContinuation(), failurePoint.getContinuation(), rows);
        failurePoint.throw_(this.location);
        w.continueAs(joinPoint);
        return w.getParameters()[0];
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        Symbol[] symbolArray = this.scrutinee;
        int n = this.scrutinee.length;
        int n2 = 0;
        while (n2 < n) {
            Expression s = symbolArray[n2];
            s.collectFreeVariables(vars);
            ++n2;
        }
        symbolArray = this.cases;
        n = this.cases.length;
        n2 = 0;
        while (n2 < n) {
            Symbol case_ = symbolArray[n2];
            ((Case)case_).collectFreeVariables(vars);
            ++n2;
        }
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        int i = 0;
        while (i < this.scrutinee.length) {
            this.scrutinee[i] = this.scrutinee[i].simplify(context);
            ++i;
        }
        Case[] caseArray = this.cases;
        int n = this.cases.length;
        int n2 = 0;
        while (n2 < n) {
            Case case_ = caseArray[n2];
            case_.simplify(context);
            ++n2;
        }
        return this;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        int i = 0;
        while (i < this.scrutinee.length) {
            this.scrutinee[i] = this.scrutinee[i].resolve(context);
            ++i;
        }
        Case[] caseArray = this.cases;
        int n = this.cases.length;
        int n2 = 0;
        while (n2 < n) {
            Case case_ = caseArray[n2];
            case_.resolve(context);
            ++n2;
        }
        return this;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            Symbol[] symbolArray = this.cases;
            int n = this.cases.length;
            int n2 = 0;
            while (n2 < n) {
                Case case_ = symbolArray[n2];
                case_.setLocationDeep(loc);
                ++n2;
            }
            symbolArray = this.scrutinee;
            n = this.scrutinee.length;
            n2 = 0;
            while (n2 < n) {
                Symbol e = symbolArray[n2];
                ((Expression)e).setLocationDeep(loc);
                ++n2;
            }
        }
    }

    @Override
    public Expression replace(ReplaceContext context) {
        Expression[] newScrutinee = new Expression[this.scrutinee.length];
        int i = 0;
        while (i < this.scrutinee.length) {
            newScrutinee[i] = this.scrutinee[i].replace(context);
            ++i;
        }
        Case[] newCases = new Case[this.cases.length];
        int i2 = 0;
        while (i2 < this.cases.length) {
            newCases[i2] = this.cases[i2].replace(context);
            ++i2;
        }
        return new EMatch(this.getLocation(), newScrutinee, newCases);
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        Type[] scrutineeTypes = new Type[this.scrutinee.length];
        int i = 0;
        while (i < this.scrutinee.length) {
            this.scrutinee[i] = this.scrutinee[i].checkType(context, Types.metaVar(Kinds.STAR));
            scrutineeTypes[i] = this.scrutinee[i].getType();
            ++i;
        }
        Case[] caseArray = this.cases;
        int n = this.cases.length;
        int n2 = 0;
        while (n2 < n) {
            Case case_ = caseArray[n2];
            case_.checkType(context, scrutineeTypes, requiredType);
            ++n2;
        }
        this.setType(requiredType);
        return this;
    }

    @Override
    public Expression decorate(ExpressionDecorator decorator) {
        int i = 0;
        while (i < this.scrutinee.length) {
            this.scrutinee[i] = this.scrutinee[i].decorate(decorator);
            ++i;
        }
        Case[] caseArray = this.cases;
        int n = this.cases.length;
        int n2 = 0;
        while (n2 < n) {
            Case case_ = caseArray[n2];
            case_.decorate(decorator);
            ++n2;
        }
        return decorator.decorate(this);
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
        Symbol[] symbolArray = this.scrutinee;
        int n = this.scrutinee.length;
        int n2 = 0;
        while (n2 < n) {
            Expression s = symbolArray[n2];
            s.collectEffects(effects);
            ++n2;
        }
        symbolArray = this.cases;
        n = this.cases.length;
        n2 = 0;
        while (n2 < n) {
            Symbol case_ = symbolArray[n2];
            Expression[] expressionArray = ((Case)case_).patterns;
            int n3 = ((Case)case_).patterns.length;
            int n4 = 0;
            while (n4 < n3) {
                Expression pattern = expressionArray[n4];
                pattern.collectEffects(effects);
                ++n4;
            }
            ((Case)case_).value.collectEffects(effects);
            ++n2;
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

