/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.SimplifiableExpression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.internal.ExpressionDecorator;
import org.simantics.scl.compiler.elaboration.java.Builtins;
import org.simantics.scl.compiler.elaboration.modules.Environment;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.parsing.contexts.TranslationContext;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class EListLiteral
extends SimplifiableExpression {
    Expression[] components;
    Type componentType;

    public EListLiteral(Expression[] components) {
        this.components = components;
    }

    public Expression[] getComponents() {
        return this.components;
    }

    @Override
    public void collectRefs(TObjectIntHashMap<SCLValue> allRefs, TIntHashSet refs) {
        Expression[] expressionArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            Expression component = expressionArray[n2];
            component.collectRefs(allRefs, refs);
            ++n2;
        }
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        Expression[] expressionArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            Expression component = expressionArray[n2];
            component.collectVars(allVars, vars);
            ++n2;
        }
    }

    @Override
    public void toString(StringBuilder b, TypeUnparsingContext tuc) {
        b.append('[');
        boolean first = true;
        Expression[] expressionArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            Expression component = expressionArray[n2];
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            component.toString(b, tuc);
            ++n2;
        }
        b.append(']');
    }

    @Override
    public void validateType(Environment environment) throws Expression.TypeValidationException {
        Expression[] expressionArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            Expression component = expressionArray[n2];
            component.validateType(environment);
            EListLiteral.assertEquals(this.location, component.getType(), this.componentType);
            ++n2;
        }
        this.setType(Types.list(this.componentType));
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        Expression[] expressionArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            Expression component = expressionArray[n2];
            component.collectFreeVariables(vars);
            ++n2;
        }
    }

    private Expression add(SimplificationContext context, Expression a, Expression b) {
        return new EApply(this.location, context.getConstant(SimplificationContext.ADD_LIST, this.componentType), a, b);
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        context.pushLocation(this.location);
        try {
            int i = 0;
            while (i < this.components.length) {
                this.components[i] = this.components[i].simplify(context);
                ++i;
            }
            if (this.components.length <= 20) {
                Expression result = new EConstant(this.location, Builtins.LIST_CONSTRUCTORS[this.components.length], this.componentType);
                if (this.components.length > 0) {
                    result = new EApply(this.location, result, this.components);
                }
                EConstant eConstant = result;
                return eConstant;
            }
            Expression result = context.getConstant(SimplificationContext.EMPTY_LIST, this.componentType);
            int i2 = 0;
            while (i2 < this.components.length) {
                result = this.add(context, result, this.components[i2]);
                ++i2;
            }
            Expression expression = result;
            return expression;
        }
        finally {
            context.popLocation();
        }
    }

    @Override
    public Expression resolve(TranslationContext context) {
        int i = 0;
        while (i < this.components.length) {
            this.components[i] = this.components[i].resolve(context);
            ++i;
        }
        return this;
    }

    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        int i = 0;
        while (i < this.components.length) {
            this.components[i] = this.components[i].resolveAsPattern(context);
            ++i;
        }
        return this;
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(Types.list(this.componentType));
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        try {
            this.componentType = Types.unifyApply(Types.LIST, requiredType);
        }
        catch (MatchException e) {
            context.getErrorLog().log(this.location, "Expected a value with type " + requiredType + " but got a list.");
            return new EError(this.location);
        }
        int i = 0;
        while (i < this.components.length) {
            this.components[i] = this.components[i].checkType(context, this.componentType);
            ++i;
        }
        return this;
    }

    @Override
    public Expression decorate(ExpressionDecorator decorator) {
        int i = 0;
        while (i < this.components.length) {
            this.components[i] = this.components[i].decorate(decorator);
            ++i;
        }
        return decorator.decorate(this);
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
        Expression[] expressionArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            Expression component = expressionArray[n2];
            component.collectEffects(effects);
            ++n2;
        }
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            Expression[] expressionArray = this.components;
            int n = this.components.length;
            int n2 = 0;
            while (n2 < n) {
                Expression component = expressionArray[n2];
                component.setLocationDeep(loc);
                ++n2;
            }
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

